/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_PERF_VIEW_H_
#define _GB2_PERF_VIEW_H_

#include <core_api/MainWindow.h>

#include <QtGui/QTreeWidget>
#include <QtGui/QTreeWidgetItem>

namespace GB2 {

class GCounter;
class PerfTreeItem;

class PerfMonitorView : public MWMDIWindow {
    Q_OBJECT
public:
    PerfMonitorView();

protected:
    void timerEvent(QTimerEvent *e);

private:
    void updateCounters();
    PerfTreeItem* findCounterItem(const GCounter* c) const; 
    QTreeWidget* tree;
};

class PerfTreeItem : public QTreeWidgetItem {
public:
    PerfTreeItem(GCounter* counter);
    GCounter* counter;
    void updateVisual();
};

} //namespace

#endif
