/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_FIND_ENZYMES_ALGO_H_
#define _GB2_FIND_ENZYMES_ALGO_H_

#include "EnzymeModel.h"

#include <core_api/Task.h>
#include <core_api/LRegion.h>
#include <core_api/DNAAlphabet.h>
#include <datatype/DNASequence.h>

#include <QtCore/QObject>
#include <QtCore/QList>

namespace GB2 {

class FindEnzymesAlgListener {
public:
    ~FindEnzymesAlgListener(){}
    virtual void onResult(int pos, const SEnzymeData& enzyme) = 0;
};


template <typename CompareFN>
class FindEnzymesAlgorithm {
public:
    void run(const DNASequence& sequence, const LRegion& range, const SEnzymeData& enzyme, FindEnzymesAlgListener* l, TaskStateInfo& ti) {
        CompareFN fn(sequence.alphabet, enzyme->alphabet);
        const char* seq = sequence.constData();
        const char* pattern = enzyme->seq.constData();
        char unknownChar = sequence.alphabet->getDefaultSymbol();
        int plen = enzyme->seq.length();
        for (int s=range.startPos, n = range.endPos() - plen + 1; s < n && !ti.cancelFlag; s++) {
            bool match = true;
            for (int p=0; p < plen && match; p++) {
                char c1 = seq[s + p];
                char c2 = pattern[p];
                match = c1!=unknownChar && fn.equals(c1, c2);
            }
            if (match) {
                l->onResult(s, enzyme);
            }
        }
    }
};

} //namespace

#endif
