/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_ENZYME_MODEL_H_
#define _GB2_ENZYME_MODEL_H_

#include <QtCore/QSharedData>
#include <QtCore/QSharedDataPointer>
#include <QtCore/QString>
#include <QtCore/QByteArray>

namespace GB2 {

#define ULOG_ENZYME_PLUGIN QString("Plugin: Enzymes")

class DNAAlphabet;
#define ENZYME_CUT_UNKNOWN 0x7FFFFF
class EnzymeData: public QSharedData {
public:
    inline EnzymeData();

    QString         id;
    QString         accession;
    QString         type;
    QByteArray      seq;
    int             cutDirect; //starts from the first char in direct strand
    int             cutComplement; // starts from the first char in complement strand, negative->right offset
    QString         organizm;
    DNAAlphabet*    alphabet;
};

EnzymeData::EnzymeData() {
    cutDirect = ENZYME_CUT_UNKNOWN;
    cutComplement = ENZYME_CUT_UNKNOWN;
    alphabet = NULL;
}

typedef QSharedDataPointer<EnzymeData> SEnzymeData;

} //namespace

#endif
