/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_GRAPHPACK_KARLIN_H_
#define _GB2_GRAPHPACK_KARLIN_H_

#include "DNAGraphPackPlugin.h"

#include <util_ov_annotated_dna/GSequenceGraphView.h>

#include <QtGui/QAction>
#include <QtCore/QList>
#include <QtCore/QBitArray>

namespace GB2 {

class KarlinGraphFactory : public GSequenceGraphFactory {
	Q_OBJECT
public:
	KarlinGraphFactory(QObject* p);
	virtual QList<GSequenceGraphData*> createGraphs(GSequenceGraphView* v);
    virtual GSequenceGraphDrawer* getDrawer(GSequenceGraphView* v);
	virtual bool isEnabled(DNASequenceObject* o) const;
};

class KarlinGraphAlgorithm : public GSequenceGraphAlgorithm {
public:
	KarlinGraphAlgorithm();
    virtual ~KarlinGraphAlgorithm();

	virtual void calculate(QVector<float>& res, DNASequenceObject* o, const LRegion& r, const GSequenceGraphWindowData* d);
private:
	float getValue (int start, int end, const QByteArray& s);
	void calculateRelativeAbundance (const char* seq, int length, float* results);


	float* global_relative_abundance_values;
	QByteArray mapTrans;
};

} // namespace
#endif
