/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include <QtGui/QFileDialog>
#include "DNAExportToCSVDialog.h"
#include "ui_DNAExportToCSVDialog.h"

namespace GB2 {

    DNAExportToCSVDialog::DNAExportToCSVDialog(QWidget *parent) :
        QDialog(parent),
        m_ui(new Ui::DNAExportToCSVDialog)
    {
        m_ui->setupUi(this);
    }

    DNAExportToCSVDialog::~DNAExportToCSVDialog()
    {
        delete m_ui;
    }

    QString DNAExportToCSVDialog::getFileName()const
    {
        return m_ui->fileNameEdit->text();
    }

    void DNAExportToCSVDialog::setFileName(QString value)
    {
        m_ui->fileNameEdit->setText(value);
    }

    bool DNAExportToCSVDialog::getExportSequence()const
    {
        return m_ui->exportSequenceCheck->isChecked();
    }

    void DNAExportToCSVDialog::setExportSequence(bool value)
    {
        m_ui->exportSequenceCheck->setChecked(value);
    }

    void DNAExportToCSVDialog::changeEvent(QEvent *e)
    {
        QDialog::changeEvent(e);
        switch (e->type()) {
        case QEvent::LanguageChange:
            m_ui->retranslateUi(this);
            break;
        default:
            break;
        }
    }

    void DNAExportToCSVDialog::on_chooseFileButton_clicked()
    {
        QString fileName;
        fileName = QFileDialog::getSaveFileName(this, QString(), QString(), tr("CSV files (*.csv);;All files (*)"));
        if(!fileName.isEmpty())
        {
            m_ui->fileNameEdit->setText(fileName);
        }
    }

} // namespace GB2
