/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_WORKFLOW_UTILS_H_
#define _GB2_WORKFLOW_UTILS_H_

#include <QtCore/QObject>
#include <QtCore/QVariant>
#include <workflow/Descriptor.h>
#include <workflow/WorkflowModel.h>
#include <workflow/IntegralBusModel.h>
#include <workflow/Schema.h>

class QListWidgetItem;

namespace GB2 {
class Descriptor;
class DocumentFormat;

class WCOREAPI_EXPORT DesignerUtils : public QObject {
    Q_OBJECT
public:
    static QString getRichDoc(const Descriptor& d);
    static void setQObjectProperties(QObject&, const QVariantMap&);
    static QString getDropUrl(QList<DocumentFormat*>& fs, const QMimeData* md);
    static QStringList expandToUrls(const QString&);

    static const QString SCHEMA_FILE_EXT;
    static QString getSchemaFileFilter(bool any);

    #define ACTOR_REF (Qt::UserRole)
    #define PORT_REF (Qt::UserRole + 1)
    #define ITERATION_REF (Qt::UserRole + 2)
    #define TEXT_REF (Qt::UserRole + 3)

    //constructs fancy list widget items with icons, must be used only within UI (when icons can be constructed)
    static bool validate(const Workflow::Schema&, QList<QListWidgetItem*>* = NULL);
    //more common version of the above method. Uses *_REFs as keys. Does not create any icons
    static bool validate(const Workflow::Schema& s, QList<QMap<int, QVariant> >* infoList );
};

using namespace Workflow;
class WCOREAPI_EXPORT PrompterBaseImpl : public ActorDocument, public Prompter {
    Q_OBJECT
public:
    PrompterBaseImpl(Actor* p = 0) : ActorDocument(p) {}

    static bool isWildcardURL(const QString& url) {return url.indexOf(QRegExp("[*?\\[\\]]")) >= 0;}

    QString getURL(const QString& id);
    QString getScreenedURL(BusPort* input, const QString& id, const QString& slot);
    QString getRequiredParam(const QString& id);
    QVariant getParameter(const QString& id);
    QString getProducers(const QString& port, const QString& slot);

    virtual QString composeRichDoc() = 0;
    virtual void update(const QVariantMap& cfg) {map = cfg; sl_actorModified();}

protected slots:
    virtual void sl_actorModified() {
        /*Actor* a = qobject_cast<Actor*>(sender());
        if (!a) {
            a = qobject_cast<Port*>(sender())->owner();
        }*/
        setHtml(QString("<center><b>%1</b></center><hr>%2")
            .arg(target->getLabel()).arg(composeRichDoc()));
    }
protected:
    QVariantMap map;
};

template <typename T>
class PrompterBase : public PrompterBaseImpl {
public:
    PrompterBase(Actor* p = 0, bool listenInputs = true) : PrompterBaseImpl(p), listenInputs(listenInputs) {}
    virtual ActorDocument* createDescription(Actor* a) {
        T* doc = new T(a);
        doc->connect(a, SIGNAL(si_labelChanged()), SLOT(sl_actorModified()));
        doc->connect(a, SIGNAL(si_modified()), SLOT(sl_actorModified()));
        if (listenInputs) {
            foreach(Workflow::Port* input, a->getInputPorts()) {
                doc->connect(input, SIGNAL(bindingChanged()), SLOT(sl_actorModified()));
            }
        }
        return doc;
    }
protected:
    bool listenInputs;
};

}//namespace

#endif

