/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_WORKFLOW_ENV_H_
#define _GB2_WORKFLOW_ENV_H_

#include <assert.h>
#include "Descriptor.h"

namespace GB2 {

class DataTypeRegistry;

namespace Workflow {

class DomainRegistry;
class WProtoRegistry;

class WCOREAPI_EXPORT WorkflowEnv {
public:
    static bool init(WorkflowEnv* instance);
    static void shutdown() { delete instance; instance = NULL;}
    static DataTypeRegistry* getDataTypeRegistry() {return getInstance()->data;}
    static WProtoRegistry* getProtoRegistry() {return getInstance()->proto;}
    static DomainRegistry* getDomainRegistry() {return getInstance()->domain;}
    virtual ~WorkflowEnv() {}

protected:
    static WorkflowEnv* instance;
    static WorkflowEnv* getInstance() {assert(instance); return instance;}

    virtual DataTypeRegistry* initDataRegistry() = 0;
    virtual WProtoRegistry* initProtoRegistry() = 0;
    virtual DomainRegistry* initDomainRegistry() = 0;


    DataTypeRegistry* data;
    WProtoRegistry* proto;
    DomainRegistry* domain;

};

} //namespace Workflow
} //namespace GB2
#endif
