/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_REMOVE_DOCUMENT_TASK_H_
#define _GB2_REMOVE_DOCUMENT_TASK_H_


#include <core_api/Task.h>

#include <QtCore/QPointer>

namespace GB2 {

class Document;
class Project;
class StateLock;

class GB2_COREAPI_EXPORT RemoveMultipleDocumentsTask : public Task {
    Q_OBJECT
public:
	RemoveMultipleDocumentsTask(Project* p, const QList<Document*>& docs, bool saveModifiedDocs, bool useGUI);
    ~RemoveMultipleDocumentsTask();

	virtual void prepare();
	
	ReportResult report();

private:
	QPointer<Project>           p;
	bool                        saveModifiedDocs;
	bool                        useGUI;
	StateLock*                  lock;
    QList<QPointer<Document> > docPtrs;
};


}//namespace

#endif
