/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef __EXTRACT_ANNOTATED_REGION_TASK_H__
#define __EXTRACT_ANNOTATED_REGION_TASK_H__

#include <core_api/Task.h>
#include <datatype/DNASequence.h>
#include <datatype/AnnotationData.h>

#include <core_api/DNATranslation.h>

namespace GB2 {

struct GB2_COREAPI_EXPORT ExtractAnnotatedRegionTaskSettings {
    ExtractAnnotatedRegionTaskSettings() : gapSym('-'), gapLength(0), translate(true), complement(true), extLeft(0), extRight(0) {}
    char gapSym;
    int gapLength;
    bool translate;
    bool complement;
    unsigned extLeft; 
    unsigned extRight;
};

class GB2_COREAPI_EXPORT ExtractAnnotatedRegionTask : public Task {
    Q_OBJECT
public:
    ExtractAnnotatedRegionTask( const DNASequence & sequence, SharedAnnotationData sd, const ExtractAnnotatedRegionTaskSettings & cfg);
    void prepare();
    void run();
    DNASequence getResultedSequence() const;
    SharedAnnotationData createResultedAnnotation();
private:
    void prepareTranslations();
    void createResultedSequence();

    DNASequence inputSeq;
    SharedAnnotationData inputAnn;
    ExtractAnnotatedRegionTaskSettings cfg;

    QList<LRegion> extendedRegions;
    DNATranslation * complT;
    DNATranslation * aminoT;

    SharedAnnotationData resultedAnn;
    DNASequence resultedSeq;
};

}// ns

#endif 
