/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_SIMPLE_TEXT_VIEW_H_
#define _GB2_SIMPLE_TEXT_VIEW_H_

#include <core_api/core_api.h>
#include <core_api/ObjectViewModel.h>
#include <selection/TextSelection.h>

#include <QtGui/QPlainTextEdit>

namespace GB2 {

class OpenSimpleTextObjectViewTask;

class GB2_COREAPI_EXPORT SimpleTextObjectViewFactory : public GObjectViewFactory {
    Q_OBJECT
public:
	SimpleTextObjectViewFactory(QObject* p = NULL);

	~SimpleTextObjectViewFactory();

	static const GObjectViewFactoryId ID;

	virtual bool canCreateView(const MultiGSelection& multiSelection);
	
	virtual bool isStateInSelection(const MultiGSelection& multiSelection, const QVariantMap& stateData);

	virtual Task* createViewTask(const MultiGSelection& multiSelection, bool single = false);

	virtual Task* createViewTask(const QString& viewName, const QVariantMap& state);

	virtual bool supportsSavedStates() const {return true;}
};

class GB2_COREAPI_EXPORT SimpleTextObjectView: public GObjectView {
	Q_OBJECT

	friend class SimpleTextObjectViewFactory;
public:
	SimpleTextObjectView(const QString& name, TextObject* to, const QVariantMap& state);

	virtual QVariantMap saveState();

	virtual Task* updateViewTask(const QString& stateName, const QVariantMap& stateData);

	virtual bool checkAddToView(const MultiGSelection& multiSelection);

	virtual Task* addToViewTask(const MultiGSelection& multiSelection);

	virtual const TextSelection& getSelectedText() {return selection;}

	virtual QWidget* createWidget();


	void updateView(const QVariantMap& stateData);

	// saved state accessors -> todo: extract into separate model class
	static QString getDocumentUrl(const QVariantMap& savedState);
    static QString getObjectName(const QVariantMap& savedState);

	static void setDocumentUrl(QVariantMap& savedState, const QString& url);

protected:
	bool eventFilter(QObject *obj, QEvent *event);

private slots:
	void sl_onTextEditTextChanged();
    void sl_onTextObjStateLockChanged();
private:
	TextObject*			textObject;
	QVariantMap			openState;
	TextSelection		selection;
	QPlainTextEdit*		textEdit;
	bool				firstShow;
};


}//namespace

#endif
