/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_CREATE_DOCUMENT_FROM_TEXT_DIALOG_CONTROLLER_H_
#define _GB2_CREATE_DOCUMENT_FROM_TEXT_DIALOG_CONTROLLER_H_

#include "ui/ui_CreateDocumentFromTextDialog.h"
#include "SeqPasterWidgetController.h"

#include <core_api/core_api.h>
#include <core_api/DocumentModel.h>
#include <util_gui/DialogUtils.h>

namespace GB2 {

class GB2_COREAPI_EXPORT CreateDocumentFromTextDialogController : public QDialog, public Ui_CreateDocumentFromTextDialog {
    Q_OBJECT
public:
    CreateDocumentFromTextDialogController(QWidget* p = NULL);

    virtual void accept();
    virtual void reject();
    Document* getDocoment(){return doc;};

private slots:
    void sl_browseButtonClicked();
    void sl_indexChanged(int index);

private:
    void addSeqPasterWidget();

    Document *doc;
    SeqPasterWidgetController *w;
    QString filter;
};

}//ns

#endif