/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_COPY_DOCUMENT_DIALOG_CONTROLLER_H_
#define _GB2_COPY_DOCUMENT_DIALOG_CONTROLLER_H_

#include "ui/ui_CopyDocumentDialog.h"

#include <core_api/core_api.h>
#include <core_api/DocumentModel.h>
#include <core_services/DocumentFormatRegistryImpl.h>

namespace GB2{

class GB2_COREAPI_EXPORT CopyDocumentDialogController : public QDialog, public Ui_CopyDocumentDialog {
    Q_OBJECT
public:
    CopyDocumentDialogController(const QString &_filter, Document* d, QWidget* p = NULL);

    virtual void accept();
    virtual void reject();
    const QString getFilename(){return fileName;}
    DocumentFormatId getDocumentFormatId(){return selectedId;};
    bool getAddToProjectFlag(){return addToProjCheck->isChecked();};

private slots:
    void sl_browseButtonClicked();
    void sl_textChanged(const QString&);
    void sl_currentIndexChanged(const QString & text);

private:

    void detectWritableFormats();

    QList<DocumentFormatId> ids;
    QString filter;
    QString fileName;
    DocumentFormatId selectedId;
};

}//ns

#endif
