/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_MSA_UTILS_H_
#define _GB2_MSA_UTILS_H_

#include <core_api/core_api.h>
#include <core_api/LRegion.h>
#include <datatype/MAlignment.h>
#include <datatype/DNASequence.h>

namespace GB2 {

class GObject;

enum MSAConsensusType {
    // return '-' if 'char' is not the only char in the row
    MSAConsensusType_Simple,
    // return '+' if there are 2+ 'chars' in a row
    // return 'char' if it's the only char in a row and its count > 2
    MSAConsensusType_Jalview,
    //Clustal files style 
    MSAConsensusType_ClustalW
};

class GB2_COREAPI_EXPORT MSAUtils : public QObject {
    Q_OBJECT
public:

    static char getConsensusChar(const MAlignment& msa, int pos, MSAConsensusType ctype);

    static void getConsensusCharAndCount(const MAlignment& msa, int pos, char& ch, int& cnt);
    
    static void updateConsensus(const MAlignment& msa, QByteArray& cons, MSAConsensusType ctype);

    static void updateConsensus(const MAlignment& msa, const LRegion& region, QByteArray& cons, MSAConsensusType ctype);

    static void updateConsensus(const MAlignment& msa, const QList<LRegion>& region, QByteArray& cons, MSAConsensusType ctype);

    static bool equalsIgnoreGaps(const QByteArray& seq, int startPos, const QByteArray& pattern);
    
    static MAlignment seq2ma(const QList<GObject*>& dnas, QString& err);

    static QList<DNASequence> ma2seq(const MAlignment& ma, bool trimGaps);

    static QString getConsensusPercentTip(const MAlignment& msa, int pos, int minReportPercent, int maxReportChars);

    // mask4 must contain 4 descending percent values (>= used), example: 100, 75, 50, 33
    // countGaps tells if to include gaps into percent computation
    // result: up to 4 most used chars (from 'A' to 'Z') are packed into return value
    // WARN: the lowest val in mask must be >= 25
    // WARN: works only for alphabet chars (A - Z)
    static quint32 packConsensusCharsToInt(const MAlignment& msa, int pos, const int* mask4, bool gapsAffectPercents);

    // up to 4 chars can be unpacked to charVal values, their percent ranges are saved to mark3Pos
    static void unpackConsensusCharsFromInt(quint32 val, char* charVal, int* maskPos);

    static void getColumnFreqs(const MAlignment& ma, int pos, QVector<int>& freqsByChar, int& nonGapChars);
};


}//namespace

#endif
