/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_GOBJECT_SELECTION_H_
#define _GB2_GOBJECT_SELECTION_H_

#include "SelectionTypes.h"

#include <core_api/SelectionModel.h>

namespace GB2 {

class GObject;

class  GB2_COREAPI_EXPORT GObjectSelection : public GSelection {
	Q_OBJECT
public:
	GObjectSelection(QObject* p = NULL) : GSelection(GSelectionTypes::GOBJECTS, p) {}
	
	const QList<GObject*>& getSelectedObjects() const {return selectedObjects;}

	virtual bool isEmpty() const {return selectedObjects.isEmpty();}

	virtual void clear();

	void setSelection(const QList<GObject*>& objs);

	void addToSelection(const QList<GObject*>& obj);

	void addToSelection(GObject* obj);

    void removeFromSelection(GObject* obj);

	void removeFromSelection(const QList<GObject*>& obj);
	
	bool contains(GObject* obj) const {return selectedObjects.contains(obj);}

signals:
	void si_selectionChanged(GObjectSelection* thiz, const QList<GObject*>& objectsAdded, const QList<GObject*>& objectsRemoved);

protected:
	virtual void _append(GObject* o) {selectedObjects.append(o);}
	virtual void _remove(GObject* o) {selectedObjects.removeAll(o);};

private:
	QList<GObject*> selectedObjects;
};



/*
class Document;
class GDocumentObjectSelection : public GObjectSelection {
	Q_OBJECT
public:
	GDocumentObjectSelection(QObject* p = NULL) : GObjectSelection(p){};

protected:
	virtual void _append(GObject* o);
	virtual void _remove(GObject* o);

private slots:
	void sl_onObjectRemoved(Document* d, GObject* o);
};


class  GProjectObjectSelection : public GObjectSelection {
	Q_OBJECT
public:
	GProjectObjectSelection(QObject* p = NULL);

private slots:
	void sl_onDocumentRemoved(Document* d);
};
*/


} //namespace
#endif
