/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include <algorithm>
#include <functional>
#include <QtCore/QtAlgorithms>

#include <core_api/AppContext.h>
#include <core_api/Settings.h>

#include "AtiStreamGpuRegistry.h"

namespace GB2 {

AtiStreamGpuRegistry::~AtiStreamGpuRegistry() {
    saveGpusSettings();
    qDeleteAll( gpus.values() );
}

void AtiStreamGpuRegistry::registerAtiStreamGpu( AtiStreamGpuModel * gpu ) {
    assert( !gpus.contains(gpu->getId()) );
    gpus.insert( gpu->getId(), gpu );
}

AtiStreamGpuModel * AtiStreamGpuRegistry::getGpuById( AtiStreamGpuId id ) const {
    return gpus.value( id, 0 );
}

QList<AtiStreamGpuModel *> AtiStreamGpuRegistry::getRegisteredGpus() const {
    return gpus.values();
}

AtiStreamGpuModel * AtiStreamGpuRegistry::getAnyEnabledGpu() const {
    QHash<AtiStreamGpuId, AtiStreamGpuModel*>::const_iterator it = std::find_if( gpus.begin(), gpus.end(), std::mem_fun(&AtiStreamGpuModel::isEnabled) );
    if( gpus.end() != it ) {
        return *it;
    }
    return 0;
}

AtiStreamGpuModel * AtiStreamGpuRegistry::acquireAnyReadyGpu() {
    QHash<AtiStreamGpuId, AtiStreamGpuModel*>::iterator it = std::find_if( gpus.begin(), gpus.end(), std::mem_fun(&AtiStreamGpuModel::isReady) );
    if( gpus.end() != it ) {
        (*it)->setAcquired(true);
        return *it;
    }
    return 0;
}

void AtiStreamGpuRegistry::saveGpusSettings() const {
    Settings * s = AppContext::getSettings();
    foreach( AtiStreamGpuModel * m, gpus ) {
        QString key = ATISTREAM_GPU_REGISTRY_SETTINGS_GPU_SPECIFIC + QString::number(m->getId()) + ATISTREAM_GPU_SETTINGS_ENABLED;
        s->setValue( key, QVariant::fromValue(m->isEnabled()) );
    }
}

} //namespace
