/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "WorkflowStarter.h"

#include <core_api/Log.h>
#include <core_api/Settings.h>

#define SETTINGS_ROOT QString("test_runner/")

namespace GB2 {

#define ULOG_CAT_WORKFLOW_STARTER "Workflow Starter"
static LogCategory log(ULOG_CAT_WORKFLOW_STARTER);

WorkflowStarter::WorkflowStarter( const QStringList& urls ) : Task(tr("Workflow loader"), TaskFlag_NoRun), urls(urls)
{
}

WorkflowStarter::~WorkflowStarter() {
}

void WorkflowStarter::prepare() {
    assert(!urls.isEmpty());
    
    
    foreach (const QString& url, urls) {
        //loading schemes
        Schema* sh=new Schema();
        sh->deepCopy = true;
        shList << sh;
        LoadWorkflowTask* loadTask = new LoadWorkflowTask(sh, NULL, url);
        addSubTask(loadTask);
    }
}

Task::ReportResult WorkflowStarter::report()
{
    return ReportResult_Finished;
}

QList<Task*> WorkflowStarter::onSubTaskFinished(Task* subTask){
    QList<Task*> res;
    if(isCanceled()){
        return res;
    }
    LoadWorkflowTask* loadTask=qobject_cast<LoadWorkflowTask*>(subTask);
    if (loadTask == NULL) {
        log.info(tr("loadTask is NULL"));
        return res;
    }
    else{
        if(loadTask->isFinished()){
            if(DesignerUtils::validate(*(loadTask->getSchema()))){
                //addSubTask();
                if (loadTask->getSchema()->domain.isEmpty()) {
                    loadTask->getSchema()->domain = WorkflowEnv::getDomainRegistry()->getAllIds().value(0);
                }
                res.append(new WorkflowRunTask(*(loadTask->getSchema()), loadTask->getSchema()->iterations));
            }else{
                //TO DO: print error
                log.error(tr("Scheme %1 is not valid").arg(loadTask->getUrl()));
                return res;
            }
        }
    }
    return res;
}

}//namespace
