/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "ProjectImpl.h"

#include <core_api/DocumentModel.h>
#include <core_api/GHints.h>
#include <core_api/Log.h>

namespace GB2 {

/* TRANSLATOR GB2::ProjectImpl */

static LogCategory log(ULOG_CAT_CORE_SERVICES);


ProjectImpl::ProjectImpl(const QString& _name, const QString& _url): name(_name), url(_url) {
	mainThreadModel = true;
}

ProjectImpl::~ProjectImpl() {
	//delete all docs
	while (!docs.isEmpty()) {
		Document* d = docs.takeLast();
		delete d;
	}
}

void ProjectImpl::makeClean() {
	if (!isTreeItemModified()) {
		return;
	}
	setModified(false);
	foreach(Document* d, docs) {
		d->makeClean();
	}
	assert(!isTreeItemModified());
}

void ProjectImpl::setProjectName(const QString& newName) {
	if (name==newName) {
		return;
	}
	setModified(true);
	name = newName;
	emit si_projectRenamed(this);
}

void ProjectImpl::setProjectURL(const QString& newURL) {
    if (url == newURL) {
        return;
    }
    
    log.details(tr("Project URL is set to %1\n").arg(newURL));

    setModified(true);
    QString oldURL = url;
    url = newURL;
    emit si_projectURLChanged(oldURL);
}

Document* ProjectImpl::findDocumentByURL(const QString& url) const {
	foreach(Document* d, docs) {
		if (d->getURL() == url) {
			return d;
		}
	}
	return NULL;
}

void ProjectImpl::addDocument(Document* d) {
	log.details(tr("add_document_url_%1").arg(d->getURL()));

	assert(findDocumentByURL(d->getURL())==NULL);
	setParentStateLockItem_static(d, this);

    d->setGHints(new ModTrackHints(this, d->getGHintsMap(), true));

	docs.push_back(d);
	emit si_documentAdded(d);
	setModified(true);
}

void ProjectImpl::removeDocument(Document* d, bool autodelete) {
	log.details(tr("remove_documenturl_%1").arg(d->getURL()));

	setParentStateLockItem_static(d, NULL);
	docs.removeOne(d);

    d->setGHints(new GHintsDefaultImpl(d->getGHints()->getMap()));

	emit si_documentRemoved(d);
	if (autodelete) {
		delete d;
	}
    setModified(true);
} 

}
