/***************************************************************************
 *   Copyright (C) 2008 by Alexey Balakin                                  *
 *   mathgl.abalakin@gmail.com                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef UDAV_H
#define UDAV_H
//-----------------------------------------------------------------------------
#include <QMainWindow>
//-----------------------------------------------------------------------------
#ifndef UDAV_VERSION
#define UDAV_VERSION	6.3
#endif

#ifndef WIN32
#define USE_HDF5	// Enable HDF "projects"
#endif

#ifndef MGL_DOC_DIR
#ifdef WIN32
#define MGL_DOC_DIR ""
#else
#define MGL_DOC_DIR "/usr/local/share/doc/udav/"
#endif
#endif
//-----------------------------------------------------------------------------
class QTextEdit;
class QFont;
class QSplitter;
class QMenu;
class QMdiArea;
class FindDialog;
class OptionDialog;
class StyleDialog;
class SetupDialog;
class InfoDialog;
class HintDialog;
class GraphWindow;
class MemoryWindow;
class HelpWindow;
class TableWindow;
class QDockWidget;
class QSpinBox;
class QMdiSubWindow;
class CalcDialog;
class DataOpenDialog;
class NewCmdDialog;
//-----------------------------------------------------------------------------
extern int MaxRecentFiles;
extern int animDelay;
//-----------------------------------------------------------------------------
class ScriptWindow: public QMainWindow
{
Q_OBJECT
public:
	GraphWindow *graph;
	MemoryWindow *info;
	HelpWindow *hlp;
	ScriptWindow(QWidget *wp=0);
	~ScriptWindow();
	void load(const QString &fileName, bool noNewWnd=false);
	void writeSettings();

public slots:
	void setEditorFont(QFont *f=0);
	void setEditPos(bool bottom);
	void editPosChanged();
	void animPutText(const QString &);
	void statusBarMessage(const QString &);

signals:
	void gotoLine(int n,int i);

protected:
	void closeEvent ( QCloseEvent* );

private slots:
	void newDoc();
	void choose();
	void save();
	void saveAs();
	void printText();
	void find();
	void about();
	void aboutQt();
	void openRecentFile();
	bool findText(const QString &str="", bool cs=false, bool fw=true);
	void replText(const QString &str, const QString &txt, bool cs=false, bool fw=true);
	void showHelp();
	void addOptions();
	void addStyle();
	void addSetup();
	void insFile();
	void insPath();
	void insFitF();
	void insNVal();

	void messClicked();
	void properties();
	void setAsterix();
	void setCursorPosition(int);
	void warnChanged();

	// Table handlers
	void loadData();
	void saveData();
	void imprt();
	void exprt();
	void copy();
	void paste();
	void plot();
	void list();
	// menu fill
	void byformula();
	void inrange();
	void norm();
	void normsl();
	// menu resize
	void create();
	void reSize();
	void squize();
	void crop();
	void transp();
	void rearrange();
	// menu change
	void smooth();
	void cumsum();
	void integr();
	void diff();
	void diff2();
	void swap();
	void mirror();
	// menu another ???
	void sumof();
	void maxof();
	void minof();
	void momentx();
	void momenty();
	void momentz();
	void hist();
	// menu operations
	void addto();
	void subto();
	void divto();
	void multo();
	// menu navigation
	void first();
	void last();
	void next();
	void prev();
	void gosl();
	void setNz(int nz);
	void subActivated(QMdiSubWindow *wnd);
	void setSlice(int);
	void putText(const QString &txt);
	void newCmd();

private:
	static int num_wnd;
	QSplitter *split;
	QPrinter *printer;
	QTextEdit *edit;	///< script itself
	QTextEdit *mess;	///< messages and warnings
	QString filename;
	FindDialog *findDialog;
	OptionDialog *optDialog;
	StyleDialog *stlDialog;
	QMenu *fileMenu, *dataMenu;
	SetupDialog *setupDlg;
	QAction *ainfo, *acalc;
	QMdiArea *mdi;
	QDockWidget *messWnd, *calcWnd;
	QToolBar *tbData[4];	///< Data toolbars
	QSpinBox *sb;			///< Slice changer for TableWindow
	CalcDialog *calc;	///< Calculator dock window
	DataOpenDialog *dataOpenDlg;
	NewCmdDialog *newCmdDlg;

	void updateRecentFileItems();
	void updateRecent();
	void setCurrentFile(const QString &fileName);
	void makeMenu();
	void makeDataMenu();
	void readSettings();
	QWidget *setupInfo(QWidget *par);
	void saveHDF5(const QString &fileName);
	void loadHDF5(const QString &fileName);
	TableWindow *activeWindow();
};
//-----------------------------------------------------------------------------
#endif
//-----------------------------------------------------------------------------
