#!/bin/sh

# Updates Makefile.am files in subdirectories with any additions or removals of icon files.

if [ ! -f "Makefile.am" ]; then
	echo "ERROR: Makefile.am not found. Cannot proceed."
	exit 1
fi

if ! grep "SUBDIRS" Makefile.am > /dev/null ; then
	echo "ERROR: SUBDIRS variable in Makefile.am not found."
	echo "Please ensure Makefile.am is up to date."
	exit 1
fi

Subdirs=$(cat Makefile.am | grep "SUBDIRS" | cut -f 3- -d ' ' | sed -e 's/ po//g')

for subdir in ${Subdirs}
do
	if [ ! -d "${subdir}" ]; then
		echo "ERROR: Subdirectory in Makefile.am not found."
		echo "Please ensure Makefile.am is up to date."
		exit 1
	fi

	Orig_Dir=$(pwd)
	cd "${subdir}"
	for dir in $(find ./ -maxdepth 1 -type d | cut -f 2- -d /)
	do
		Orig_Subdir=$(pwd)
		cd "${dir}"
		for pngfile in $(find ./ -maxdepth 1 -type f -name "*.png" | cut -f 2- -d /)
		do
			if [ -z "${Icon_Files_Png}" ]; then
				Icon_Files_Png="${pngfile}"
			else
				Icon_Files_Png="${Icon_Files_Png} ${pngfile}"
			fi
		done

		for svgfile in $(find ./ -maxdepth 1 -type f -name "*.svg" | cut -f 2- -d /)
		do
			if [ -z "${Icon_Files_Svg}" ]; then
				Icon_Files_Svg="${svgfile}"
			else
				Icon_Files_Svg="${Icon_Files_Svg} ${svgfile}"
			fi
		done

		cat <<EOF > Makefile.am
# This is a script generated file. PLEASE DO NOT EDIT BY HAND!
# Please run update-build-files.sh from the top level directory to
# re-generate this file.

size = ${subdir}
context = ${dir}

iconsdir = \$(themedir)/\$(size)/\$(context)

icons_DATA = ${Icon_Files_Png} ${Icon_Files_Svg}

install-data-local: install-iconsDATA
	(cd \$(DESTDIR)\$(themedir)/\$(size) && \$(ICONMAP) -c \$(context))

EXTRA_DIST =                           \\
       \$(icons_DATA)

MAINTAINERCLEANFILES = Makefile.in
EOF

		unset Icon_Files_Png Icon_Files_Svg
		cd "${Orig_Subdir}"
		Icon_Dirs="${Icon_Dirs} ${dir}"
	done

	cat <<EOF > Makefile.am
# This is a script generated file. PLEASE DO NOT EDIT BY HAND!
# Please run update-build-files.sh from the top level directory to
# re-generate this file.

SUBDIRS = ${Icon_Dirs}

MAINTAINERCLEANFILES = Makefile.in
EOF

	cd "${Orig_Dir}"
	unset Icon_Files_Png Icon_Files_Svg Icon_Dirs Orig_Dir Orig_Subdir
done

for makefile in $(find . -type f -name Makefile.am | cut -f 2- -d / | grep -v ^Makefile.am | cut -f 1 -d .)
do
	if [ -z "${Makefiles}" ]; then
		Makefiles="${makefile}"
	else
		Makefiles="${Makefiles}\n${makefile}"
	fi
done
cat configure.ac-template | sed -e "s#@MAKEFILES@#$Makefiles#g" > configure.ac
