#!/usr/bin/env python
# 
# Copyright 2009 Canonical, Ltd
# Author: Brian Murray <brian@ubuntu.com>
# License: GPLv3
# 
# 2009-12-10
# Find packages that do not have any subscribers
# and may be neglected

from launchpadlib.launchpad import Launchpad
from launchpadlib.uris import LPNET_SERVICE_ROOT
from launchpadlib.errors import HTTPError
from launchpadlib.credentials import Credentials

import os, sys, itertools, time

cachedir = os.path.expanduser("~/.launchpadlib/cache/")

if not os.path.exists(cachedir):
    os.makedirs(cachedir,0700)

script_name = sys.argv[0].split("/")[-1].split('.')[0]

credfile = os.path.expanduser('~/.launchpadlib/%s.cred' % script_name)

root = LPNET_SERVICE_ROOT

try:
    credentials = Credentials()
    credentials.load(open(credfile))
    launchpad = Launchpad(credentials, root, cachedir)
except:
    launchpad = Launchpad.get_token_and_login(script_name, root, cachedir)
    launchpad.credentials.save(open(credfile,"w",0600)) 
    
ubuntu = launchpad.distributions['ubuntu']

# find all the published source packages
series = ubuntu.getSeries(name_or_version="lucid")
archive = ubuntu.main_archive

tries = 0

while tries <= 10:
    try:
        pubs = archive.getPublishedSources(status="Published", distro_series=series)
        tries = 11
    except HTTPError, e:
        time.sleep(10)
        print tries
        tries += 1
        continue
tries = 0
#pubs = archive.getPublishedSources(status="Published", distro_series=series)

quantity = pubs._wadl_resource.representation['total_size']
print quantity
#while tries <= 10:
#    try:
#for pub in pubs:
start = 0
end = 100
while start <= quantity:
    while tries <= 10:
        try:
            for pub in archive.getPublishedSources(status="Published", distro_series=series)[start:end]:
                #print pub
#        #while tries <= 10:
#            #try:
                package_name = pub.source_package_name 
                package = ubuntu.getSourcePackage(name=package_name)
    
                subscriptions = package.getSubscriptions()
    
                if int(subscriptions._wadl_resource.representation['total_size']) == 0:
                    print "%s has no subscribers" % package_name
                tries = 0
            start += 100
            end += 100
        except HTTPError, e:
            time.sleep(10)
            tries += 1
            continue
