//-*-c++-*-
/**
 Authors: David Auber, Patrick Mary, Morgan Mathiaut
 from the LaBRI Visualization Team
 Email : auber@tulip-software.org
 Last modification : 13/03/2009 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by  
 the Free Software Foundation; either version 2 of the License, or     
 (at your option) any later version.
*/
#ifndef MORPHING_H
#define MORPHING_H

#ifndef DOXYGEN_NOTFOR_USER
#include <vector>
#include <tulip/Camera.h>
#include <tulip/Coord.h>
#include <tulip/Edge.h>

#include <QtGui/qevent.h>
#include <QtCore/qdatetime.h>
#include <QtCore/qobject.h>
#include <tulip/tulipconf.h>

#define	MORPHING_MAX_FPS	30


namespace tlp {

  class GlMainWidget;
  class Graph;
  class LayoutProperty;
  class SizeProperty;
  class ColorProperty;
  //=====================================
  struct TLP_QT_SCOPE GraphState {
    Graph *g;
    LayoutProperty *layout;
    SizeProperty *size;
    ColorProperty *color;
    Camera *camera;
    std::vector<std::vector<Coord> > augPoints;
    std::vector<Coord> augCenters;
    std::vector<std::vector<Coord> > curInterpolation;
    std::vector<Coord> interpolateCenters;

    GraphState( GlMainWidget * glgw );
    ~GraphState();
    static bool setupDiff( Graph * inG, GraphState * inGS0, GraphState * inGS1 );
    void EdgeEnds( Coord & outC0, Coord & outC1, edge e );
  };
  //=====================================
  class TLP_QT_SCOPE Morphing : public QObject {
  public:
    Morphing();
    bool init(GlMainWidget * outGlgw, 
	      GraphState * inG0, 
	      GraphState * inG1);
    void interpolate( GlMainWidget *, float inT);
    bool start(GlMainWidget * outGlgw);
    
  protected:
    void timerEvent( QTimerEvent * );
    void stop();
    float fps();

  private: 
    GraphState *g0, *g1;
    LayoutProperty *e0, *e1;
    GlMainWidget *glWidget;
    QTime qt0;
    int frameCpt; 
    int tid;
    float t;
  };
  //=====================================
}

#endif //DOXYGEN_NOTFOR_USER
#endif //MORPHING_H
