//-*-c++-*-
/**
 Authors: David Auber, Romain Bourqui, Patrick Mary
 from the LaBRI Visualization Team
 Email : auber@tulip-software.org
 Last modification : 13/07/2007 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by  
 the Free Software Foundation; either version 2 of the License, or     
 (at your option) any later version.
*/

#include "tulip/GlHudCircle.h"

namespace tlp {

  //===================================================
  GlHudCircle::GlHudCircle(const Coord &center, float radius, 
			   const Color &outlineColor,
			   const Color &fillColor,
			   bool filled, bool outlined ,
			   float startAngle,
			   unsigned int segments) :
    GlHudPolygon(segments, 1u, 1u, filled, outlined) {
    fcolor(0) = fillColor;
    ocolor(0) = outlineColor;
    set(center, radius, startAngle);
  }
  
  void  GlHudCircle::set(const Coord &center, float radius, float startAngle) {
    float delta = (2.0f * M_PI) / (float)_points.size();
    for (unsigned int i=0; i < _points.size(); ++i) {
      float deltaX = cos(startAngle + i * delta) * (radius);
      float deltaY = sin(startAngle + i * delta) * (radius);
      _points[i] = Coord(center[0] + deltaX, center[1] + deltaY, center[2]);
    }
  }
}
