//-*-c++-*-
/**
 Authors: David Auber, Romain Bourqui, Patrick Mary
 from the LaBRI Visualization Team
 Email : auber@tulip-software.org
 Last modification : 13/07/2007 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by  
 the Free Software Foundation; either version 2 of the License, or     
 (at your option) any later version.
*/
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <iostream>
#include <cmath>

#include <tulip/Coord.h>
#include "tulip/GlGraph.h"
#include <GL/gl.h>
#include <GL/glu.h>

using namespace std;
using namespace tlp;
//==========================================================
/*
Coord GlGraph::getSceneTranslation() const {
  return sceneTranslation;
}
*/
//==========================================================
//void GlGraph::setSceneTranslation(const Coord &c){
//  TRACE_EXEC(); 
//  sceneTranslation=c;
//}
//==========================================================
/*Coord GlGraph::getSceneRotation() const {
  return sceneRotation;
}
*/
//==========================================================
/*void GlGraph::setSceneRotation(const Coord &c) {
  TRACE_EXEC(); 
  sceneRotation = c;
}
*/
//==========================================================
void GlGraph::translateCamera(const int x, const int y, const int z) {
  Coord v1(0, 0, 0);
  Coord v2(x, y, z);
  v1 = screenTo3DWorld(v1);
  v2 = screenTo3DWorld(v2);
  Coord move = v2 - v1;
  Camera camera =   _renderingParameters.getCamera();
  camera.eyes   += move;
  camera.center += move;
  _renderingParameters.setCamera(camera);
  setRenderingParameters(_renderingParameters);
}
//==========================================================
void GlGraph::zoom(int step) {
  Camera camera = _renderingParameters.getCamera();
  camera.zoomFactor *= pow(1.1, step);
  _renderingParameters.setCamera(camera);
  setRenderingParameters(_renderingParameters);
}
//================================================
void GlGraph::rotateScene(const int x, const int y, const int z) {
  //  cerr << __PRETTY_FUNCTION__ << endl;
  Camera camera = _renderingParameters.getCamera();
  camera.rotate(float(x)/360.0 * M_PI, 1.0, 0, 0);
  camera.rotate(float(y)/360.0 * M_PI, 0, 1.0, 0);
  camera.rotate(float(z)/360.0 * M_PI, 0, 0, 1.0);
  _renderingParameters.setCamera(camera);
  setRenderingParameters(_renderingParameters);
}
//==================================================
void GlGraph::zoomXY(int step, const int x, const int y) {
  Camera camera = _renderingParameters.getCamera();
  camera.zoomFactor*=pow(1.1,step);
  _renderingParameters.setCamera(camera);
  setRenderingParameters(_renderingParameters);
  /* translation factor:
   * the farther from the center of the screen, the higher the factor (and the higher the resulting translation)
   */
  Vector<int, 4> viewport = _renderingParameters.getViewport();
  if (step < 0) step *= -1;
  int factX = (int)(step*(double(viewport[2])/2.0-x)/ 7.0);
  int factY = (int)(step*(double(viewport[3])/2.0-y)/ 7.0);
  translateCamera(factX,-factY,0);
}
