//-*-c++-*-
/**
 Authors: David Auber, Romain Bourqui, Patrick Mary
 from the LaBRI Visualization Team
 Email : auber@tulip-software.org
 Last modification : 13/07/2007 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by  
 the Free Software Foundation; either version 2 of the License, or     
 (at your option) any later version.
*/

#ifndef _GL_AUGMENTED_DISPLAY_H_
#define _GL_AUGMENTED_DISPLAY_H_

#include <map>

#include <tulip/Coord.h>
#include <tulip/Color.h>
#include <tulip/GlGraph.h>
#include <GL/glu.h> 

#include "tulip/GlADRenderOptions.h"

namespace tlp {
/** \brief General class to render augmented displays
 *
 * This class is a generic class to render augmented display, it is the mother-class of all the GlAD classes
 *
 */
class TLP_GL_SCOPE GlAugmentedDisplay {

 public:
  /**
   * Destructor
   */
  virtual ~GlAugmentedDisplay();

  /**
   * Virtual function used to draw the augmented display
   */
  virtual void draw(GlGraph* graph);

  /**
   * Virtual function used to trigger when changeing render options
   */
  virtual void changeRenderOptions();

  /**
   * Setup function for the rendering options
   * \attention Must absolutely be called with unsetup in every derivated class
   * \attention You call setup(), you render, you call unsetup()
   */
  virtual void setup();

  /**
   * Unsetup function for the rendering options
   * \attention Must absolutely be called with setup in every derivated class
   * \attention You call setup(), you render, you call unsetup()
   */  
  virtual void unsetup();
  /**
   * Accessor in writing to the rendering options
   */
  void setRenderOptions(const GlADRenderOptions &renderOptions);

  /**
   * Interface to set a renderState to the current RenderingOptions of the GlAD
   */
  void setRenderState(GlADRenderState renderState, bool value);

  /**
   * Interface ot get a renderState to the current RenderingOptions of the GlAD
   */
  bool getRenderState(GlADRenderState renderState) const; 

 protected:
  // ** Rendering options **
  GlADRenderOptions renderOptions; /**< Rendering options */
};
}
#endif
