//-*-c++-*-
/**
 Authors: David Auber, Romain Bourqui, Patrick Mary
 from the LaBRI Visualization Team
 Email : auber@tulip-software.org
 Last modification : 13/07/2007 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by  
 the Free Software Foundation; either version 2 of the License, or     
 (at your option) any later version.
*/

#ifndef _GLAD_LINE_H_
#define _GLAD_LINE_H_

#include "GlAugmentedDisplay.h"

namespace tlp {
  /** \brief General class to render lines as augmented displays
   * 
   * This class is a generic class to render lines as augmented displays.
   */
  class TLP_GL_SCOPE GlADLine : public GlAugmentedDisplay {
  public:
    /**
     * Constructor
     *
     * \param startPosition Indicates the first point of the line.
     * \param endPosition Indicates the last point of the line.
     * \param startColor Indicates the color of the first point of the line.
     * \param endColor Indicates the color of the last point of the line.
     * \param thickness Indicates the thickness of the line.
     */
    GlADLine(const Coord& startPosition, 
	     const Coord& endPosition, 
	     const Color& startColor, 
	     const Color& endColor, 
	     const unsigned int thickness);

    /**
     * Destructor.
     */
    virtual ~GlADLine();

    /**
     * Virtual function used to draw the line.
     */
    virtual void draw(GlGraph* graph);

    /**
     * Accessor in reading to the start position of the line.
     */
    Coord getStartPosition() const;

    /**
     * Accessor int reading to the end position of the line.
     */
    Coord getEndPosition() const;  

    /**
     * Accessor in reading to the start color of the line.
     */
    Color getStartColor() const;

    /**
     * Accessor in reading to the end color of the line.
     */
    Color getEndColor() const;

    /**
     * Accessor in reading to the thickness of the line.
     */
    unsigned int getThickness() const;

    /**
     * Accessor in writing to the start position of the line.
     */
    void setStartPosition(const Coord& startPosition);

    /**
     * Accessor in writing to the end position of the line.
     */
    void setEndPosition(const Coord& endPosition);

    /**
     * Accessor in writing to the start color of the line.
     */
    void setStartColor(const Color& startColor);

    /**
     * Accessor in writing to the end color of the line.
     */
    void setEndColor(const Color& endColor);

    /**
     * Accessor in writing to the thickness of the line.
     */
    void setThickness(int thickness);

  protected:
    Coord startPosition; /**< The start position of the line */
    Coord endPosition; /**< The end position of the line.*/
    Color startColor; /**<The start color of the line.*/
    Color endColor; /**< The end color of the line.*/
    unsigned int thickness;  /**< The thickness of the line */
  };
}
#endif
