/*
    Tucnak - VHF contest log
    Copyright (C) 2002-2006  Ladislav Vaiz <ok1zia@nagano.cz>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "header.h"


char tname[MAX_STR_LEN],pcall[MAX_STR_LEN],pclub[MAX_STR_LEN];
char pwwlo[MAX_STR_LEN],pexch[MAX_STR_LEN],tdate[MAX_STR_LEN];
int qsoused;
char qsomult_str[MAX_STR_LEN];
int wwlused;
char wwlbonu_str[MAX_STR_LEN], wwlmult_str[MAX_STR_LEN];
int excused;
char excbonu_str[MAX_STR_LEN], excmult_str[MAX_STR_LEN];
char dxcbonu_str[MAX_STR_LEN], dxcmult_str[MAX_STR_LEN];
int rstused;
char default_rst[MAX_STR_LEN],default_rs[MAX_STR_LEN];
int modesep;

/*int qsop_method=1, total_method=1;*/

/******************** BAND SETTINGS *******************************/

#define RESP_LEN 50
int qrvnow,psect,qrv,readonly;
char stxeq[RESP_LEN], spowe[RESP_LEN], srxeq[RESP_LEN], sante[RESP_LEN];
char santh[RESP_LEN], mope1[RESP_LEN], mope2[RESP_LEN];
char remarks[RESP_LEN];

/*struct config_band *b;*/

void refresh_band_confb(void *xxx)
{
    struct config_band *confb;
        
/*    dbg("refresh_band_confb\n");    */
    confb=(struct config_band *)xxx;


    confb->qrvnow = qrvnow;
    confb->psect  = psect;
    confb->qrv    = qrv;
    confb->readonly = readonly;
    dbg("refresh_band readonly=%d\n", readonly);
    STORE_STR(confb,stxeq);
/*    dbg("refresh_band confb=%p confb->stxeq='%s'\n",confb,confb->stxeq);*/
    /*b=confb;*/
    STORE_STR(confb,spowe);
    STORE_STR(confb,srxeq);
    STORE_STR(confb,sante);
    STORE_STR(confb,santh);
    STORE_STR(confb,mope1);
    STORE_STR(confb,mope2);
    STORE_STR(confb,remarks);
}

void refresh_band(void *xxx)
{
    struct band *band;
        
/*    dbg("refresh_band\n");    */
    band=(struct band *)xxx;

/*  band->qrv = qrvnow;*/ 
    band->psect  = psect;
    /*band->qrv    = qrv;*/
    band->readonly = readonly;
    il_readonly(band->il, band->readonly);
    STORE_STR(band,stxeq);
/*    dbg("refresh_band band=%p band->stxeq='%s'\n",band,band->stxeq);*/
    STORE_STR(band,spowe);
    STORE_STR(band,srxeq);
    STORE_STR(band,sante);
    STORE_STR(band,santh);
    STORE_STR(band,mope1);
    STORE_STR(band,mope2);
    STORE_STR(band,remarks);
}

char *band_msg[] = {
    CTEXT(T_QRV_ON_THIS_BAND),
    CTEXT(T_QRV_IN_THIS_CTEST),
    CTEXT(T_READ_ONLY),
    CTEXT(T_MULTI),
    CTEXT(T_SINGLE),
    CTEXT(T_CHECK),
    CTEXT(T_TXEQUIP),
    CTEXT(T_POWER),
    CTEXT(T_RXEQUIP),
    CTEXT(T_ANTENNA),
    CTEXT(T_AGLASL),
    CTEXT(T_OPS),
    CTEXT(T_SPACES1),
    CTEXT(T_REMARKS),
    "", /* OK */        
    "", /* Cancel */
};
void band_fn(struct dialog_data *dlg)
{
    struct terminal *term = dlg->win->term;
    int max = 0, min = 0;
    int w, rw;
    int y = -1;

    max_group_width(term, band_msg + 0, dlg->items + 0, 5, &max);
    min_group_width(term, band_msg + 0, dlg->items + 0, 5, &min);
    max_group_width(term, band_msg + 6, dlg->items + 6, 1, &max);
    min_group_width(term, band_msg + 6, dlg->items + 6, 1, &min);
    max_group_width(term, band_msg + 7, dlg->items + 7, 1, &max);
    min_group_width(term, band_msg + 7, dlg->items + 7, 1, &min);
    max_group_width(term, band_msg + 8, dlg->items + 8, 1, &max);
    min_group_width(term, band_msg + 8, dlg->items + 8, 1, &min);
    max_group_width(term, band_msg + 9, dlg->items + 9, 1, &max);
    min_group_width(term, band_msg + 9, dlg->items + 9, 1, &min);
    max_group_width(term, band_msg +10, dlg->items +10, 1, &max);
    min_group_width(term, band_msg +10, dlg->items +10, 1, &min);
    max_group_width(term, band_msg +11, dlg->items +11, 1, &max);
    min_group_width(term, band_msg +11, dlg->items +11, 1, &min);
    max_group_width(term, band_msg +12, dlg->items +12, 1, &max);
    min_group_width(term, band_msg +12, dlg->items +12, 1, &min);
    max_group_width(term, band_msg +13, dlg->items +13, 1, &max);
    min_group_width(term, band_msg +13, dlg->items +13, 1, &min);
    
    max_buttons_width(term, dlg->items +14, 2, &max);
    min_buttons_width(term, dlg->items +14, 2, &min);
    
    w = dlg->win->term->x * 9 / 10 - 2 * DIALOG_LB;
    if (w > max) w = max;
    if (w < min) w = min;
    if (w > dlg->win->term->x - 2 * DIALOG_LB) w = dlg->win->term->x - 2 * DIALOG_LB;
    if (w < 1) w = 1;
    
    rw = 0;
    y ++;
    dlg_format_group1(NULL, term, band_msg + 0, dlg->items + 0, 3, 0, &y, w, &rw);
    dlg_format_group1(NULL, term, band_msg + 3, dlg->items + 3, 3, 0, &y, w, &rw);
    y++;
    dlg_format_group(NULL, term, band_msg + 6, dlg->items + 6, 1, 0, &y, w, &rw);
    dlg_format_group(NULL, term, band_msg + 7, dlg->items + 7, 1, 0, &y, w, &rw);
    dlg_format_group(NULL, term, band_msg + 8, dlg->items + 8, 1, 0, &y, w, &rw);
    dlg_format_group(NULL, term, band_msg + 9, dlg->items + 9, 1, 0, &y, w, &rw);
    dlg_format_group(NULL, term, band_msg +10, dlg->items +10, 1, 0, &y, w, &rw);
    dlg_format_group(NULL, term, band_msg +11, dlg->items +11, 1, 0, &y, w, &rw);
    dlg_format_group(NULL, term, band_msg +12, dlg->items +12, 1, 0, &y, w, &rw);
    dlg_format_group(NULL, term, band_msg +13, dlg->items +13, 1, 0, &y, w, &rw);
    y++;
    dlg_format_buttons(NULL, term, dlg->items +14, 2, 0, &y, w, &rw, AL_CENTER);
    

    w = rw;
    dlg->xw = w + 2 * DIALOG_LB;
    dlg->yw = y + 2 * DIALOG_TB;

    
    center_dlg(dlg);
    draw_dlg(dlg);
    y = dlg->y + DIALOG_TB;
    y++;
    dlg_format_group1(term, term, band_msg + 0, dlg->items + 0, 3, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group1(term, term, band_msg + 3, dlg->items + 3, 3, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    y++;
    dlg_format_group(term, term, band_msg + 6, dlg->items + 6, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group(term, term, band_msg + 7, dlg->items + 7, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group(term, term, band_msg + 8, dlg->items + 8, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group(term, term, band_msg + 9, dlg->items + 9, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group(term, term, band_msg +10, dlg->items +10, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group(term, term, band_msg +11, dlg->items +11, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group(term, term, band_msg +12, dlg->items +12, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group(term, term, band_msg +13, dlg->items +13, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    y++;
    dlg_format_buttons(term, term, dlg->items +14, 2, dlg->x + DIALOG_LB, &y, w, NULL, AL_CENTER);
    
}


                                                   

/* xxx is char *band */
void band_settings(struct terminal *term, void *xxx, void *from_ctest)
{
    struct dialog *d;
    int i,found;
    char *pband=(char *)xxx;
    struct config_band *confb=NULL;
    struct band *band=NULL;
    static char ss[1024];

    found=0;

    if (!from_ctest)
        for (i=0;i<cfg->bands->len; i++){

            confb = (struct config_band*)g_ptr_array_index(cfg->bands,i);
            if (!confb) break;
            if (strcasecmp(pband, confb->pband)==0){
                found=1;
                break;
            }
        }
    else
        for (i=0;i<ctest->bands->len; i++){

            band = (struct band*)g_ptr_array_index(ctest->bands,i);
            if (!band) break;
            if (strcasecmp(pband, band->pband)==0){
                found=1;
                break;
            }
        }

    
    if (!found){ raise(SIGSEGV); }
    
    if (confb){
        qrvnow=confb->qrvnow;
        psect=confb->psect;
        qrv=confb->qrv;
        readonly=confb->readonly;
        dbg("band_settings readonly=%d\n", readonly);
        safe_strncpy0(stxeq,confb->stxeq,RESP_LEN);
        safe_strncpy0(spowe,confb->spowe,RESP_LEN);
        safe_strncpy0(srxeq,confb->srxeq,RESP_LEN);
        safe_strncpy0(sante,confb->sante,RESP_LEN);
        safe_strncpy0(santh,confb->santh,RESP_LEN);
        safe_strncpy0(mope1,confb->mope1,RESP_LEN);    uc(mope1);
        safe_strncpy0(mope2,confb->mope2,RESP_LEN);    uc(mope2);
        safe_strncpy0(remarks,confb->remarks,RESP_LEN);
    }else{
        qrvnow=1;
        psect=band->psect;
        qrv=1;
        readonly=band->readonly;
        safe_strncpy0(stxeq,band->stxeq,RESP_LEN);
        safe_strncpy0(spowe,band->spowe,RESP_LEN);
        safe_strncpy0(srxeq,band->srxeq,RESP_LEN);
        safe_strncpy0(sante,band->sante,RESP_LEN);
        safe_strncpy0(santh,band->santh,RESP_LEN);
        safe_strncpy0(mope1,band->mope1,RESP_LEN);    uc(mope1);
        safe_strncpy0(mope2,band->mope2,RESP_LEN);    uc(mope2);
        safe_strncpy0(remarks,band->remarks,RESP_LEN);
    }

    if (!(d = mem_alloc(sizeof(struct dialog) + 55 * sizeof(struct dialog_item)))) return;
    memset(d, 0, sizeof(struct dialog) + 55 * sizeof(struct dialog_item));
    d->title = ss;
    d->fn = band_fn;
    if (confb){
        g_snprintf(ss,1000,TEXT(T_BAND_SETTINGS_SC), upcase(confb->bandchar),pband);
        d->refresh = (void (*)(void *))refresh_band_confb;
        d->refresh_data = confb;
    }else{
        g_snprintf(ss,1000,TEXT(T_BAND_SETTINGS_SC), upcase(band->bandchar),pband);
        d->refresh = (void (*)(void *))refresh_band;
        d->refresh_data = band;
    }
    

    d->items[i=0].type = D_CHECKBOX;
    d->items[i].gid  = 0;
    d->items[i].gnum = 1;
    d->items[i].dlen = sizeof(int);
    d->items[i].data = (char *)&qrv;
    
    d->items[++i].type = D_CHECKBOX;
    d->items[i].gid  = 0;
    d->items[i].gnum = 1;
    d->items[i].dlen = sizeof(int);
    d->items[i].data = (char *)&qrvnow;
    
    d->items[++i].type = D_CHECKBOX;
    d->items[i].gid  = 0;
    d->items[i].gnum = 1;
    d->items[i].dlen = sizeof(int);
    d->items[i].data = (char *)&readonly;
    
    d->items[++i].type = D_CHECKBOX;
    d->items[i].gid  = 1;
    d->items[i].gnum = 0;
    d->items[i].dlen = sizeof(int);
    d->items[i].data = (char *)&psect;
    
    d->items[++i].type = D_CHECKBOX;
    d->items[i].gid  = 1;
    d->items[i].gnum = 1;
    d->items[i].dlen = sizeof(int);
    d->items[i].data = (char *)&psect;
    
    d->items[++i].type = D_CHECKBOX;
    d->items[i].gid  = 1;
    d->items[i].gnum = 2;
    d->items[i].dlen = sizeof(int);
    d->items[i].data = (char *)&psect;
    
    d->items[++i].type = D_FIELD;
    d->items[i].dlen = RESP_LEN;
    d->items[i].data = stxeq;
                
    d->items[i=7].type = D_FIELD;
    d->items[i].dlen = 10;
    d->items[i].data = spowe;
    
    d->items[++i].type = D_FIELD;
    d->items[i].dlen = RESP_LEN;
    d->items[i].data = srxeq;
    
    d->items[++i].type = D_FIELD;
    d->items[i].dlen = RESP_LEN;
    d->items[i].data = sante;
    
    d->items[++i].type = D_FIELD;
    d->items[i].dlen = 10;
    d->items[i].data = santh;
    
    d->items[i=11].type = D_FIELD;
    d->items[i].dlen = RESP_LEN;
    d->items[i].data = mope1;
    
    d->items[++i].type = D_FIELD;
    d->items[i].dlen = RESP_LEN;
    d->items[i].data = mope2;
    
    d->items[++i].type = D_FIELD;
    d->items[i].dlen = RESP_LEN;
    d->items[i].data = remarks;
    
    d->items[++i].type = D_BUTTON;
    d->items[i].gid = B_ENTER;
    d->items[i].fn = ok_dialog;
    d->items[i].text = TEXT(T_OK);
    
    d->items[++i].type = D_BUTTON;
    d->items[i].gid = B_ESC;
    d->items[i].fn = cancel_dialog;
    d->items[i].text = TEXT(T_CANCEL);
    
    d->items[++i].type = D_END;
    do_dialog_(term, d, getml(d, NULL));
}
                               

int dlg_band_settings_confb(struct dialog_data *dlg, struct dialog_item_data *di){
    /*dbg("dlg_band_settings %p %p \n",dlg,di);*/
    band_settings(dlg->win->term, di->item->text, NULL); 
    return 0;
}

int dlg_band_settings(struct dialog_data *dlg, struct dialog_item_data *di){
    /*dbg("dlg_band_settings %p %p \n",dlg,di);*/
    band_settings(dlg->win->term, di->item->text, (void*)43); 
    return 0;
}


/******************** RESPONSIBLE OPERATOR *******************************/

#define RESP_LEN 50
char rname[RESP_LEN], rcall[RESP_LEN], radr1[RESP_LEN], radr2[RESP_LEN];
char rpoco[RESP_LEN], rcity[RESP_LEN], rcoun[RESP_LEN];
char rphon[RESP_LEN], rhbbs[RESP_LEN];
                                                   
void refresh_responsible_op(void *xxx)
{
/*    dbg("refresh_responsible_op\n");*/
    STORE_STR(cfg,rname);
    STORE_STR(cfg,rcall);
    STORE_STR(cfg,radr1);
    STORE_STR(cfg,radr2);
    STORE_STR(cfg,rpoco);
    STORE_STR(cfg,rcity);
    STORE_STR(cfg,rcoun);
    STORE_STR(cfg,rphon);
    STORE_STR(cfg,rhbbs);
}

char *responsible_op_msg[] = {
    CTEXT(T_NAME),
    CTEXT(T_CALLSIGN),
    CTEXT(T_ADDRESS),
    CTEXT(T_ADDRESS),
    CTEXT(T_POSTCODE),
    CTEXT(T_CITY),
    CTEXT(T_COUNTRY),
    CTEXT(T_PHONE),
    CTEXT(T_BBSEMAIL),
    "", /* OK */        /* 9 */
    "", /* Cancel */
};
void responsible_op_fn(struct dialog_data *dlg)
{
    struct terminal *term = dlg->win->term;
    int max = 0, min = 0;
    int w, rw;
    int y = -1;

    max_group_width(term, responsible_op_msg + 0, dlg->items + 0, 1, &max);
    min_group_width(term, responsible_op_msg + 0, dlg->items + 0, 1, &min);
    max_group_width(term, responsible_op_msg + 1, dlg->items + 1, 1, &max);
    min_group_width(term, responsible_op_msg + 1, dlg->items + 1, 1, &min);
    max_group_width(term, responsible_op_msg + 2, dlg->items + 2, 1, &max);
    min_group_width(term, responsible_op_msg + 2, dlg->items + 2, 1, &min);
    max_group_width(term, responsible_op_msg + 3, dlg->items + 3, 1, &max);
    min_group_width(term, responsible_op_msg + 3, dlg->items + 3, 1, &min);
    max_group_width(term, responsible_op_msg + 4, dlg->items + 4, 1, &max);
    min_group_width(term, responsible_op_msg + 4, dlg->items + 4, 1, &min);
    max_group_width(term, responsible_op_msg + 5, dlg->items + 5, 1, &max);
    min_group_width(term, responsible_op_msg + 5, dlg->items + 5, 1, &min);
    max_group_width(term, responsible_op_msg + 6, dlg->items + 6, 1, &max);
    min_group_width(term, responsible_op_msg + 6, dlg->items + 6, 1, &min);
    max_group_width(term, responsible_op_msg + 7, dlg->items + 7, 1, &max);
    min_group_width(term, responsible_op_msg + 7, dlg->items + 7, 1, &min);
    max_group_width(term, responsible_op_msg + 8, dlg->items + 8, 1, &max);
    min_group_width(term, responsible_op_msg + 8, dlg->items + 8, 1, &min);
    
    max_buttons_width(term, dlg->items + 9, 2, &max);
    min_buttons_width(term, dlg->items + 9, 2, &min);
    
    w = dlg->win->term->x * 9 / 10 - 2 * DIALOG_LB;
    if (w > max) w = max;
    if (w < min) w = min;
    if (w > dlg->win->term->x - 2 * DIALOG_LB) w = dlg->win->term->x - 2 * DIALOG_LB;
    if (w < 1) w = 1;
    
    rw = 0;
    y ++;
    dlg_format_group(NULL, term, responsible_op_msg + 0, dlg->items + 0, 1, 0, &y, w, &rw);
    dlg_format_group(NULL, term, responsible_op_msg + 1, dlg->items + 1, 1, 0, &y, w, &rw);
    dlg_format_group(NULL, term, responsible_op_msg + 2, dlg->items + 2, 1, 0, &y, w, &rw);
    dlg_format_group(NULL, term, responsible_op_msg + 3, dlg->items + 3, 1, 0, &y, w, &rw);
    dlg_format_group(NULL, term, responsible_op_msg + 4, dlg->items + 4, 1, 0, &y, w, &rw);
    dlg_format_group(NULL, term, responsible_op_msg + 5, dlg->items + 5, 1, 0, &y, w, &rw);
    dlg_format_group(NULL, term, responsible_op_msg + 6, dlg->items + 6, 1, 0, &y, w, &rw);
    dlg_format_group(NULL, term, responsible_op_msg + 7, dlg->items + 7, 1, 0, &y, w, &rw);
    dlg_format_group(NULL, term, responsible_op_msg + 8, dlg->items + 8, 1, 0, &y, w, &rw);
    y++;
    dlg_format_buttons(NULL, term, dlg->items +9, 2, 0, &y, w, &rw, AL_LEFT);
    
    
    w = rw;
    dlg->xw = w + 2 * DIALOG_LB;
    dlg->yw = y + 2 * DIALOG_TB;

    
    center_dlg(dlg);
    draw_dlg(dlg);
    y = dlg->y + DIALOG_TB;
    y++;
    dlg_format_group(term, term, responsible_op_msg + 0, dlg->items + 0, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group(term, term, responsible_op_msg + 1, dlg->items + 1, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group(term, term, responsible_op_msg + 2, dlg->items + 2, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group(term, term, responsible_op_msg + 3, dlg->items + 3, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group(term, term, responsible_op_msg + 4, dlg->items + 4, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group(term, term, responsible_op_msg + 5, dlg->items + 5, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group(term, term, responsible_op_msg + 6, dlg->items + 6, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group(term, term, responsible_op_msg + 7, dlg->items + 7, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group(term, term, responsible_op_msg + 8, dlg->items + 8, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    y++;
    dlg_format_buttons(term, term, dlg->items +9, 2, dlg->x + DIALOG_LB, &y, w, NULL, AL_LEFT);
    
}



void responsible_op(struct terminal *term, void *xxx, void *yyy)
{
    struct dialog *d;
    int i;

    safe_strncpy0(rname,cfg->rname,RESP_LEN);
    safe_strncpy0(rcall,cfg->rcall,RESP_LEN); uc(rcall);
    safe_strncpy0(radr1,cfg->radr1,RESP_LEN);
    safe_strncpy0(radr2,cfg->radr2,RESP_LEN);
    safe_strncpy0(rpoco,cfg->rpoco,RESP_LEN);
    safe_strncpy0(rcity,cfg->rcity,RESP_LEN);
    safe_strncpy0(rcoun,cfg->rcoun,RESP_LEN);
    safe_strncpy0(rphon,cfg->rphon,RESP_LEN);
    safe_strncpy0(rhbbs,cfg->rhbbs,RESP_LEN); 
    

    if (!(d = mem_alloc(sizeof(struct dialog) + 55 * sizeof(struct dialog_item)))) return;
    memset(d, 0, sizeof(struct dialog) + 55 * sizeof(struct dialog_item));
    d->title = TEXT(T_RESPOP);
    d->fn = responsible_op_fn;
    d->refresh = (void (*)(void *))refresh_responsible_op;
    

    d->items[i=0].type = D_FIELD;
    d->items[i].dlen = RESP_LEN;
    d->items[i].data = rname;
    
    d->items[i=1].type = D_FIELD;
    d->items[i].dlen = RESP_LEN;
    d->items[i].data = rcall;
    
    d->items[i=2].type = D_FIELD;
    d->items[i].dlen = RESP_LEN;
    d->items[i].data = radr1;
    
    d->items[i=3].type = D_FIELD;
    d->items[i].dlen = RESP_LEN;
    d->items[i].data = radr2;
    
    d->items[i=4].type = D_FIELD;
    d->items[i].dlen = RESP_LEN;
    d->items[i].data = rpoco;
    
    d->items[i=5].type = D_FIELD;
    d->items[i].dlen = RESP_LEN;
    d->items[i].data = rcity;
    
    d->items[i=6].type = D_FIELD;
    d->items[i].dlen = RESP_LEN;
    d->items[i].data = rcoun;
    
    d->items[i=7].type = D_FIELD;
    d->items[i].dlen = RESP_LEN;
    d->items[i].data = rphon;
    
    d->items[i=8].type = D_FIELD;
    d->items[i].dlen = RESP_LEN;
    d->items[i].data = rhbbs;
    
    d->items[++i].type = D_BUTTON;
    d->items[i].gid = B_ENTER;
    d->items[i].fn = ok_dialog;
    d->items[i].text = TEXT(T_OK);
    
    d->items[++i].type = D_BUTTON;
    d->items[i].gid = B_ESC;
    d->items[i].fn = cancel_dialog;
    d->items[i].text = TEXT(T_CANCEL);
    
    d->items[++i].type = D_END;
    do_dialog_(term, d, getml(d, NULL));
}
                               

int dlg_responsoble_op(struct dialog_data *dlg, struct dialog_item_data *di){
    responsible_op(dlg->win->term, NULL, NULL); 
    return 0;
}

void menu_responsible_op(struct terminal *term, void *xxx, struct session *ses){
    responsible_op(term, NULL, NULL); 
} 

/******************** QSOP METHOD, TOTAL METHOD  ******************/

#define MAX_QSOP_METHOD 11
#define MAX_TOTAL_METHOD 2

int qsop_method=1, total_method=1;
char qsop_method_str[MAX_STR_LEN],total_method_str[MAX_STR_LEN];

char *qsop_method_msg[]={
    CTEXT(T_QP0),
    CTEXT(T_QP1),
    CTEXT(T_QP2),
    CTEXT(T_QP3),
    CTEXT(T_QP4),
    CTEXT(T_QP5),
    CTEXT(T_QP6),
    CTEXT(T_QP7),
    CTEXT(T_QP8),
    CTEXT(T_QP9),
    CTEXT(T_QP10),
    CTEXT(T_QP11)
};

char *total_method_msg[]={
    CTEXT(T_TP0),
    CTEXT(T_TP1),
    CTEXT(T_TP2)
};


void qsop_method_func (struct terminal *term, void *ip, void *d){
    int active;

    active=(vint)ip;
    if (active<1 || active>MAX_QSOP_METHOD) return;
    qsop_method = active;
    /*safe_strncpy0(qsop_method_str, qsop_method_msg[qsop_method], MAX_STR_LEN);*/
    safe_strncpy0(qsop_method_str,_(CTEXT(T_QP0+qsop_method),term),MAX_STR_LEN);
    redraw_later(term);
}

int dlg_qsop_method(struct dialog_data *dlg, struct dialog_item_data *di){
    int i, sel;
    struct menu_item *mi;
    
    if (!(mi = new_menu(1))) return 0;
    for (i = 1; i <= MAX_QSOP_METHOD; i++) {
        add_to_menu(&mi, qsop_method_msg[i], "", "", MENU_FUNC qsop_method_func, (void *)(vint)i, 0);
    }
    sel = qsop_method-1;
    if (sel < 0) sel = 0;
    if (sel>=MAX_QSOP_METHOD) sel=0;
    do_menu_selected(term, mi, (void *)(vint)qsop_method, sel);
    return 0;
}

void total_method_func (struct terminal *term, void *ip, void *d){
    int active;

    active=(vint)ip;
    if (active<1 || active>MAX_TOTAL_METHOD) return;
    total_method = active;
/*    safe_strncpy0(total_method_str, total_method_msg[total_method], MAX_STR_LEN);*/
    safe_strncpy0(total_method_str,_(CTEXT(T_TP0+total_method),term),MAX_STR_LEN);
    redraw_later(term);
    return;
}

int dlg_total_method(struct dialog_data *dlg, struct dialog_item_data *di){
    int i, sel;
    struct menu_item *mi;
    
    if (!(mi = new_menu(1))) return 0;
    for (i = 1; i <= MAX_TOTAL_METHOD; i++) {
        add_to_menu(&mi, total_method_msg[i], "", "", MENU_FUNC total_method_func, (void *)(vint)i, 0);
    }
    sel = total_method-1;
    if (sel < 0) sel = 0;
    if (sel>=MAX_TOTAL_METHOD) sel=0;
    do_menu_selected(term, mi, (void *)(vint)total_method, sel);
    return 0;
}


/******************** WIZZ *******************************************/

void wizz_func (struct terminal *term, void *ip, void *d){
    int active;
    struct wizz_item *wi;
    time_t now;
    struct tm *utc;

    active=(vint)ip;
    if (active<0 || active>=wizz->items->len) return;
    wi = get_wizz(wizz, active);

    time(&now);
    utc=gmtime(&now);

    safe_strncpy0(tname, wi->tname,100);
    safe_strncpy0(pcall, cfg->pcall, 20);uc(pcall);
    safe_strncpy0(pclub, cfg->pclub, 20);uc(pclub);
    safe_strncpy0(pwwlo, cfg->pwwlo, 9); uc(pwwlo);
    safe_strncpy0(pexch, wi->pexch, 9); uc(pexch);
    g_snprintf(tdate, MAX_STR_LEN, "%d%02d%02d", 1900+utc->tm_year, 1+utc->tm_mon, utc->tm_mday);
    qsoused=wi->qsoused;
    g_snprintf(qsomult_str,10, "%d", wi->qsomult);
    wwlused=wi->wwlused;
    g_snprintf(wwlbonu_str,10, "%d", wi->wwlbonu);
    g_snprintf(wwlmult_str,10, "%d", wi->wwlmult);
    excused=wi->excused;
    if (wi->pexchtype && *wi->pexchtype) excused=1;
    g_snprintf(excbonu_str,10, "%d", wi->excbonu);
    g_snprintf(excmult_str,10, "%d", wi->excmult);
    g_snprintf(dxcbonu_str,10, "%d", wi->dxcbonu);
    g_snprintf(dxcmult_str,10, "%d", wi->dxcmult);
    rstused=wi->rstused;
    safe_strncpy(default_rs, cfg->default_rs, 5);    uc(default_rs);
    safe_strncpy(default_rst, cfg->default_rst, 5);  uc(default_rst);

    
    qsop_method=wi->qsop_method;
    /*safe_strncpy0(qsop_method_str,qsop_method_msg[qsop_method],MAX_STR_LEN);*/
    safe_strncpy0(qsop_method_str,_(CTEXT(T_QP0+qsop_method),term),MAX_STR_LEN);
    total_method=wi->total_method;
    safe_strncpy0(total_method_str,_(CTEXT(T_TP0+total_method),term),MAX_STR_LEN);
    /*safe_strncpy0(total_method_str,total_method_msg[total_method],MAX_STR_LEN);*/
    
    /* wwltype */
    /* minqsop, maxqsop */
    
    contest_options1(term, TEXT(T_NEW_CTEST), NULL);
}


struct menu_item no_wizz[] = {
    {CTEXT(T_NO_CTESTS), "", M_BAR, NULL, NULL, 0, 0},
    {NULL, NULL, 0, NULL, NULL, 0, 0}
};


void menu_wizz(struct terminal *term, void *xxx, void *yyy){
    int i;
    struct menu_item *mi;
    struct wizz_item *wi;
    
    if (!wizz->items->len){
        do_menu_(term, no_wizz, gses);
        return;
    }
    
    if (!(mi = new_menu(1))) return;
    for (i = 0; i < wizz->items->len; i++) {
        wi = get_wizz(wizz, i);
        add_to_menu(&mi, wi->tname, "", "", MENU_FUNC wizz_func, (void *)(vint)i, 0);
    }
    do_menu_selected(term, mi, NULL, 0);
}

/******************** CONTEST OPTIONS 1 *******************************/

/*char qsop_method_str[MAX_STR_LEN],total_method_str[MAX_STR_LEN];*/

int save_desc_to_file(gchar *filename){
    gchar *pcall, *s;
    FILE *f;
    int ret;

    if (filename){
        f = fopen(filename, "wt");
        if (!f) return 1;
    }else{
        /* dialog contest options, desc remains locked */
        f=ctest->descfile;
        fseek(f, SEEK_SET, 0);
        if (ftruncate(fileno(f), 0)){
            log_addf("Can't ftruncate(desc,0), errno=%d\n", errno);
        }
    }
    
    pcall=g_strdup(ctest->pcall);
    s = g_strdup_printf("%s %s %s\n", ctest->cdate, uc(pcall), ctest->tname);    
    ret = fprintf(f, "%s", s) != strlen(s);
    g_free(pcall);
    g_free(s);

    if (filename){
        fclose(f);
    }
    return ret;
    
}

void update_desc(struct contest *ctest){
    if (!ctest) return;
    if (!ctest->pcall) return;
    if (!ctest->tname) return;
    
    if (!ctest->pcall ||
        !ctest->tname ||
        strcasecmp(pcall, ctest->pcall) ||
        strcasecmp(tname, ctest->tname)){

        setvbuf(ctest->descfile, NULL, _IONBF, 0);
        fseek(ctest->descfile, 0, SEEK_SET);
        if (ftruncate(fileno(ctest->descfile), 0)){
            errbox(TEXT(T_CANT_TRUNC), errno);
            return;
        }
        fprintf(ctest->descfile,"%s %s %s\n", ctest->cdate, uc(pcall), ctest->tname);    
    }
    
}

void refresh_contest_options1(void *xxx)
{
    int isnew=0;
    /*dbg("refresh_contest_options1\n");*/

    update_desc(ctest);
    
    if (!ctest) isnew=1;
    
    STORE_STR_FS_UC(cfg,pcall); 
    STORE_STR_FS_UC(cfg,pclub);
    STORE_STR_FS_UC(cfg,pwwlo);
    STORE_STR_FS   (cfg,default_rst);
    STORE_STR_FS   (cfg,default_rs);
    
    if (init_ctest()) return;
    
    STORE_STR_FS   (ctest,tname);
    STORE_STR_FS_UC(ctest,pcall);
    STORE_STR_FS_UC(ctest,pclub);
    STORE_STR_FS_UC(ctest,pwwlo);
    STORE_STR_FS_UC(ctest,pexch);
    /* tdate is handled by argument */
    STORE_STR_FS   (ctest,default_rst);
    STORE_STR_FS   (ctest,default_rs);
    
    STORE_STR2   (ctest,cfg,rname);
    STORE_STR2_UC(ctest,cfg,rcall);
    STORE_STR2   (ctest,cfg,radr1);
    STORE_STR2   (ctest,cfg,radr2);
    STORE_STR2   (ctest,cfg,rpoco);
    STORE_STR2   (ctest,cfg,rcity);
    STORE_STR2   (ctest,cfg,rcoun);
    STORE_STR2   (ctest,cfg,rphon);
    STORE_STR2   (ctest,cfg,rhbbs);
    
    STORE_INT (ctest,qsoused);
    STORE_SINT(ctest,qsomult);

    STORE_INT (ctest,wwlused);
    STORE_SINT(ctest,wwlbonu);
    STORE_SINT(ctest,wwlmult);
    STORE_INT (ctest,excused);
    STORE_SINT(ctest,excbonu);
    STORE_SINT(ctest,excmult);
    STORE_SINT(ctest,dxcbonu);
    STORE_SINT(ctest,dxcmult);
    STORE_INT (ctest,rstused);
    STORE_INT (ctest,qsop_method);
    STORE_INT (ctest,total_method);
    STORE_INT (ctest,modesep);
    
    set_ctest_title(term);

    if (!isnew){               /* contest options from menu */
        gchar *descfile;
        
        recalc_all_qrbqtf(ctest);
        recalc_all_stats(ctest);
        save_all_bands_txt(0);

        descfile=g_strdup_printf("%s/desc", ctest->directory);
        save_desc_to_file(NULL);
        g_free(descfile);

        net_send_ac();
        net_send_operator();
#ifdef HAVE_SDL     
        gfx_update_qth();
        invalidate_cache(aband);
#endif      
        return;
    }
    
    /* new contest */
    if (new_ctest(tdate)) return;

    if (init_qrv_bands()) return;
    save_all_bands_txt(0);
    net_send_ac();
    net_send_operator();

    if (cfg->startband){
        struct band *b;
        b=find_band_by_pband(cfg->startband);
        activate_band(gses, b); /* b==NULL is handled by function */
    }
    
}

char *contest_options1_msg[] = {
    CTEXT(T_NAME_OF_CTEST), /* 0 */
    CTEXT(T_CALL_OF_CTEST),
    CTEXT(T_CLUB_ST), 
    CTEXT(T_YOURWWL), 
    CTEXT(T_YOUREXC),
    CTEXT(T_DATE_OF_CTEST),           /* 5 */
    CTEXT(T_QSOUSED),       
    CTEXT(T_QSOPM),
    CTEXT(T_WWLUSED),     
    CTEXT(T_WWLB),
    CTEXT(T_WWLM),   /* 10 */
    CTEXT(T_EXCUSED),    
    CTEXT(T_EXCB),
    CTEXT(T_EXCM),
    CTEXT(T_DXCB),
    CTEXT(T_DXCM),    /* 15 */
    CTEXT(T_RSTUSED),    
    CTEXT(T_DEFRS),
    CTEXT(T_DEFRST), 
    CTEXT(T_QP_CALC),
    CTEXT(T_TO_CALC),
    CTEXT(T_MODESEP),
    "","","","","","","","","","","","","","","","","","","","","","","","","","",
    "", /* OK */        /* 21 */
    "", /* Cancel */
    "", /* EDI properties */
    "", /* Responsible operator */ 
};
void contest_options1_fn(struct dialog_data *dlg)
{
    struct terminal *term = dlg->win->term;
    int max = 0, min = 0;
    int w, rw;
    int y = -1;
    int firstbandbutt, numofbands;

    /*dbg("contest_options1_fn()\n");*/
    firstbandbutt=22;
    for (numofbands=0; numofbands<26; numofbands++ ) {
        if (! dlg->items[firstbandbutt+numofbands].item) break;
        if (dlg->items[firstbandbutt+numofbands].item->type!= D_BUTTON) break;
        if (dlg->items[firstbandbutt+numofbands].item->gid== B_ENTER) break;
    }
/*    dbg("first=%d, num=%d\n",firstbandbutt,numofbands);*/
            
            
            

    max_group_width(term, contest_options1_msg + 0, dlg->items + 0, 1, &max);
    min_group_width(term, contest_options1_msg + 0, dlg->items + 0, 1, &min);
    max_group_width(term, contest_options1_msg + 1, dlg->items + 1, 2, &max);
    min_group_width(term, contest_options1_msg + 1, dlg->items + 1, 2, &min);
    max_group_width(term, contest_options1_msg + 3, dlg->items + 3, 3, &max);
    min_group_width(term, contest_options1_msg + 3, dlg->items + 3, 3, &min);
    max_group_width(term, contest_options1_msg + 6, dlg->items + 6, 2, &max);
    min_group_width(term, contest_options1_msg + 6, dlg->items + 6, 2, &min);
    max_group_width(term, contest_options1_msg + 8, dlg->items + 8, 3, &max);
    min_group_width(term, contest_options1_msg + 8, dlg->items + 8, 3, &min);
    max_group_width(term, contest_options1_msg +11, dlg->items +11, 3, &max);
    min_group_width(term, contest_options1_msg +11, dlg->items +11, 3, &min);
    max_group_width(term, contest_options1_msg +14, dlg->items +14, 2, &max);
    min_group_width(term, contest_options1_msg +14, dlg->items +14, 2, &min);
    max_group_width(term, contest_options1_msg +16, dlg->items +16, 3, &max);
    min_group_width(term, contest_options1_msg +16, dlg->items +16, 3, &min);
    max_group_width(term, contest_options1_msg +19, dlg->items +19, 2, &max);
    min_group_width(term, contest_options1_msg +19, dlg->items +19, 2, &min);
    
    max_group_width(term, contest_options1_msg + 21, dlg->items + 21, 1, &max);
    min_group_width(term, contest_options1_msg + 21, dlg->items + 21, 1, &min);

    max_group_width(term, contest_options1_msg +firstbandbutt, dlg->items +firstbandbutt, numofbands, &max);
    min_group_width(term, contest_options1_msg +firstbandbutt, dlg->items +firstbandbutt, numofbands, &min);
    
    max_buttons_width(term, dlg->items + firstbandbutt+numofbands, 4, &max);
    min_buttons_width(term, dlg->items + firstbandbutt+numofbands, 4, &min);
    
    w = dlg->win->term->x * 9 / 10 - 2 * DIALOG_LB;
    if (w > max) w = max;
    if (w < min) w = min;
    if (w > dlg->win->term->x - 2 * DIALOG_LB) w = dlg->win->term->x - 2 * DIALOG_LB;
    if (w < 1) w = 1;
    
    rw = 0;
    y ++;
    /*dlg_format_text(NULL, term, contest_options1_msg  +0, 0, &y, w, &rw, COLOR_DIALOG_TEXT, AL_LEFT);
    y ++;*/
    dlg_format_group(NULL, term, contest_options1_msg + 0, dlg->items + 0, 1, 0, &y, w, &rw);
    y ++;
    dlg_format_group(NULL, term, contest_options1_msg + 1, dlg->items + 1, 2, 0, &y, w, &rw);
    dlg_format_group(NULL, term, contest_options1_msg + 3, dlg->items + 3, 3, 0, &y, w, &rw);
    y++;
    dlg_format_group(NULL, term, contest_options1_msg + 6, dlg->items + 6, 2, 0, &y, w, &rw);
    dlg_format_group(NULL, term, contest_options1_msg + 8, dlg->items + 8, 3, 0, &y, w, &rw);
    dlg_format_group(NULL, term, contest_options1_msg +11, dlg->items +11, 3, 0, &y, w, &rw);
    dlg_format_group(NULL, term, contest_options1_msg +14, dlg->items +14, 2, 0, &y, w, &rw);
    dlg_format_group(NULL, term, contest_options1_msg +16, dlg->items +16, 3, 0, &y, w, &rw);
    dlg_format_group1(NULL, term, contest_options1_msg+19, dlg->items +19, 2, 0, &y, w, &rw);
    dlg_format_group(NULL, term, contest_options1_msg +21, dlg->items +21, 1, 0, &y, w, &rw);
    y++;
    dlg_format_group1(NULL, term, contest_options1_msg +firstbandbutt, dlg->items +firstbandbutt, numofbands, 0, &y, w, &rw);
    y++;
    dlg_format_buttons(NULL, term, dlg->items +firstbandbutt+numofbands , 4, 0, &y, w, &rw, AL_CENTER);
    
    
    w = rw;
    dlg->xw = w + 2 * DIALOG_LB;
    dlg->yw = y + 2 * DIALOG_TB;

    
    center_dlg(dlg);
    draw_dlg(dlg);
    y = dlg->y + DIALOG_TB;
    y++;
    dlg_format_group(term, term, contest_options1_msg + 0, dlg->items + 0, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group(term, term, contest_options1_msg + 1, dlg->items + 1, 2, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group(term, term, contest_options1_msg + 3, dlg->items + 3, 3, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    y++;
    dlg_format_group(term, term, contest_options1_msg + 6, dlg->items + 6, 2, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group(term, term, contest_options1_msg + 8, dlg->items + 8, 3, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group(term, term, contest_options1_msg +11, dlg->items +11, 3, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group(term, term, contest_options1_msg +14, dlg->items +14, 2, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group(term, term, contest_options1_msg +16, dlg->items +16, 3, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group1(term, term, contest_options1_msg+19, dlg->items +19, 2, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group(term, term, contest_options1_msg +21, dlg->items +21, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    y++;
    dlg_format_group1(term, term, contest_options1_msg +firstbandbutt, dlg->items +firstbandbutt, numofbands, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    y++;
    dlg_format_buttons(term, term, dlg->items +firstbandbutt+numofbands, 4, dlg->x + DIALOG_LB, &y, w, NULL, AL_CENTER);
}

    
void contest_options1(struct terminal *term, char *title, void *from_ctest)
{
    struct dialog *d;
    int i,j;

    /*dbg("contest_options1\n");*/
    
    if (!(d = mem_alloc(sizeof(struct dialog) + 60 * sizeof(struct dialog_item)))) return;
    memset(d, 0, sizeof(struct dialog) + 60 * sizeof(struct dialog_item));
    d->title = title;
    d->fn = contest_options1_fn;
    d->refresh = (void (*)(void *))refresh_contest_options1;
    
    
    d->items[i=0].type = D_FIELD;
    d->items[i].dlen = MAX_STR_LEN;
    d->items[i].data = tname;
    d->items[i].maxl = 45;
    
    d->items[++i].type = D_FIELD;
    d->items[i].dlen = 20;
    d->items[i].data = pcall;
    d->items[i].maxl = 15;
    
    d->items[++i].type = D_FIELD;
    d->items[i].dlen = 20;
    d->items[i].data = pclub;
    d->items[i].maxl = 15;
    
    d->items[++i].type = D_FIELD;
    d->items[i].dlen = 9;
    d->items[i].data = pwwlo;
    
    d->items[++i].type = D_FIELD;
    d->items[i].dlen = 9;
    d->items[i].data = pexch;
    
    d->items[++i].type = D_FIELD;     /* 5 */
    d->items[i].dlen = 9;
    d->items[i].data = tdate;
    
    d->items[++i].type = D_CHECKBOX;  
    d->items[i].gid = 0;
    d->items[i].gnum = 1;
    d->items[i].dlen = sizeof(int);
    d->items[i].data=(char *)&qsoused;
    
    d->items[++i].type = D_FIELD;
    d->items[i].data = qsomult_str;
    d->items[i].dlen = 3;
    d->items[i].fn   = check_number;
    d->items[i].gid  = 0;
    d->items[i].gnum = 100;
    
    
    d->items[++i].type = D_CHECKBOX;
    d->items[i].gid = 0;
    d->items[i].gnum = 1;
    d->items[i].dlen = sizeof(int);
    d->items[i].data=(char *)&wwlused;
    
    d->items[++i].type = D_FIELD;
    d->items[i].data = wwlbonu_str;
    d->items[i].dlen = 3;
    d->items[i].fn   = check_number;
    d->items[i].gid  = 0;
    d->items[i].gnum = 999;
    
    d->items[++i].type = D_FIELD;      /* 10 */
    d->items[i].data = wwlmult_str;
    d->items[i].dlen = 3;
    d->items[i].fn   = check_number;
    d->items[i].gid  = 0;
    d->items[i].gnum = 100;
    
    
    d->items[++i].type = D_CHECKBOX;   
    d->items[i].gid = 0;
    d->items[i].gnum = 1;
    d->items[i].dlen = sizeof(int);
    d->items[i].data=(char *)&excused;
    
    d->items[++i].type = D_FIELD;
    d->items[i].data = excbonu_str;
    d->items[i].dlen = 3;
    d->items[i].fn   = check_number;
    d->items[i].gid  = 0;
    d->items[i].gnum = 999;
    
    d->items[++i].type = D_FIELD;
    d->items[i].data = excmult_str;
    d->items[i].dlen = 3;
    d->items[i].fn   = check_number;
    d->items[i].gid  = 0;
    d->items[i].gnum = 100;
    
    
    d->items[++i].type = D_FIELD;
    d->items[i].data = dxcbonu_str;
    d->items[i].dlen = 3;
    d->items[i].fn   = check_number;
    d->items[i].gid  = 0;
    d->items[i].gnum = 999;
    
    d->items[++i].type = D_FIELD;      /* 15 */
    d->items[i].data = dxcmult_str;
    d->items[i].dlen = 3;
    d->items[i].fn   = check_number;
    d->items[i].gid  = 0;
    d->items[i].gnum = 100;
    
    
    d->items[++i].type = D_CHECKBOX;   
    d->items[i].gid = 0;
    d->items[i].gnum = 1;
    d->items[i].dlen = sizeof(gint);
    d->items[i].data=(char *)&rstused;
    
    d->items[++i].type = D_FIELD;
    d->items[i].data = default_rs;
    d->items[i].dlen = 5;
    
    d->items[++i].type = D_FIELD;
    d->items[i].data = default_rst;
    d->items[i].dlen = 5;
    
    
    d->items[++i].type = D_BUTTON;      /* 19 */
    d->items[i].gid  = 0;
    d->items[i].fn   = dlg_qsop_method;
    d->items[i].text = qsop_method_str;
    
    d->items[++i].type = D_BUTTON;     
    d->items[i].gid  = 0;
    d->items[i].fn   = dlg_total_method;
    d->items[i].text = total_method_str;

    d->items[++i].type = D_CHECKBOX;
    d->items[i].gid = 0;
    d->items[i].gnum = 1;
    d->items[i].dlen = sizeof(int);
    d->items[i].data=(char *)&modesep;
    

    /*    dbg("firstband=%d\n",i+1);*/
    if (!from_ctest){
        for (j=0;j<26;j++){
            struct config_band *confb;

            if (j>=cfg->bands->len) break; /* no config file */
            
            confb = (struct config_band*)g_ptr_array_index(cfg->bands,j);
            if (!confb) break;  /* unreached? */
            if (!confb->qrvnow) continue;
            
            d->items[++i].type = D_BUTTON;
            d->items[i].gid  = 0;
            d->items[i].fn   = dlg_band_settings_confb; 
            d->items[i].text = confb->pband;
        }
    }else{
        for (j=0;j<ctest->bands->len;j++){
            struct band *band;

            band = (struct band*)g_ptr_array_index(ctest->bands,j);
            if (!band) break;  /* unreached? */
            
            d->items[++i].type = D_BUTTON;
            d->items[i].gid  = 0;
            d->items[i].fn   = dlg_band_settings;
            d->items[i].text = band->pband;
        }
    }
/*    dbg("lastband=%d\n",i);*/
    
    d->items[++i].type = D_BUTTON;
    d->items[i].gid = B_ENTER;
    d->items[i].fn = ok_dialog;
    d->items[i].text = TEXT(T_OK);
    
    d->items[++i].type = D_BUTTON;
    d->items[i].gid = B_ESC;
    d->items[i].fn = cancel_dialog;
    d->items[i].text = TEXT(T_CANCEL);
    
    d->items[++i].type = D_BUTTON;
    d->items[i].gid = 0;                         
    d->items[i].fn = dlg_edi_prop;
    d->items[i].text = TEXT(T_EDI_PROP);
    
    d->items[++i].type = D_BUTTON;
    d->items[i].gid = 0;
    d->items[i].fn = dlg_responsoble_op;
    d->items[i].text = TEXT(T_RESPOP2);
    
    d->items[++i].type = D_END;
    do_dialog_(term, d, getml(d, NULL));
}


void contest_options1_from_menu(struct terminal *term, void *xxx, void *yyy)
{
    time_t now;
    struct tm *utc;

    time(&now);
    utc=gmtime(&now);

    /*dbg("contest_options1\n");*/
    safe_strncpy0(tname,"",100);
    safe_strncpy0(pcall, cfg->pcall, 20);uc(pcall);
    safe_strncpy0(pclub, cfg->pclub, 20);uc(pclub);
    safe_strncpy0(pwwlo, cfg->pwwlo, 9); uc(pwwlo);
    safe_strncpy0(pexch, cfg->pexch, 9); uc(pexch);
    g_snprintf(tdate, MAX_STR_LEN, "%d%02d%02d", 1900+utc->tm_year, 1+utc->tm_mon, utc->tm_mday);
    qsoused=1;
    safe_strncpy(qsomult_str,"1", 10);
    wwlused=1;
    safe_strncpy(wwlbonu_str,"0",10);
    safe_strncpy(wwlmult_str,"0",10);
    excused=0; 
    safe_strncpy(excbonu_str,"0",10);
    safe_strncpy(excmult_str,"0",10);
    safe_strncpy(dxcbonu_str,"0",10);
    safe_strncpy(dxcmult_str,"0",10);
    rstused=1;
    safe_strncpy0(default_rs, cfg->default_rs, 5);    uc(default_rs);
    safe_strncpy0(default_rst, cfg->default_rst, 5);  uc(default_rst);
    qsop_method=cfg->qsop_method % MAX_QSOP_METHOD;
    safe_strncpy0(qsop_method_str,_(CTEXT(T_QP0+qsop_method),term),MAX_STR_LEN);
    /*safe_strncpy0(qsop_method_str,qsop_method_msg[qsop_method],MAX_STR_LEN);*/
    total_method=cfg->total_method % MAX_TOTAL_METHOD;
    safe_strncpy0(total_method_str,_(CTEXT(T_TP0+total_method),term),MAX_STR_LEN);
    /*safe_strncpy0(total_method_str,total_method_msg[total_method],MAX_STR_LEN);*/
    modesep=0;
   
    contest_options1(term, TEXT(T_NEW_CTEST), NULL);
}
                               

void contest_options1_from_ctest(struct terminal *term, void *xxx, void *yyy)
{
    time_t now;
    struct tm *utc;

    time(&now);
    utc=gmtime(&now);

    /*dbg("contest_options1\n");*/
    safe_strncpy0(tname, ctest->tname,100);
    safe_strncpy0(pcall, ctest->pcall, 20);uc(pcall);
    safe_strncpy0(pclub, ctest->pclub, 20);uc(pclub);
    safe_strncpy0(pwwlo, ctest->pwwlo, 9); uc(pwwlo);
    safe_strncpy0(pexch, ctest->pexch, 9); uc(pexch);
/*  g_snprintf(tdate, MAX_STR_LEN, "%d%02d%02d", 1900+utc->tm_year, 1+utc->tm_mon, utc->tm_mday);*/
    qsoused=ctest->qsoused;
    g_snprintf(qsomult_str,10, "%d", ctest->qsomult);
    wwlused=ctest->wwlused;
    g_snprintf(wwlbonu_str,10, "%d", ctest->wwlbonu);
    g_snprintf(wwlmult_str,10, "%d", ctest->wwlmult);
    excused=ctest->excused;
    g_snprintf(excbonu_str,10, "%d", ctest->excbonu);
    g_snprintf(excmult_str,10, "%d", ctest->excmult);
    g_snprintf(dxcbonu_str,10, "%d", ctest->dxcbonu);
    g_snprintf(dxcmult_str,10, "%d", ctest->dxcmult);
    rstused=ctest->rstused;
    safe_strncpy0(default_rs, cfg->default_rs, 5);    uc(default_rs);
    safe_strncpy0(default_rst, cfg->default_rst, 5);  uc(default_rst);
    
    qsop_method=ctest->qsop_method;
    safe_strncpy0(qsop_method_str,_(CTEXT(T_QP0+qsop_method),term),MAX_STR_LEN);
    /*safe_strncpy0(qsop_method_str,qsop_method_msg[qsop_method],MAX_STR_LEN);*/
    total_method=ctest->total_method;
    safe_strncpy0(total_method_str,_(CTEXT(T_TP0+total_method),term),MAX_STR_LEN);
    /*safe_strncpy0(total_method_str,total_method_msg[total_method],MAX_STR_LEN);*/
    modesep=ctest->modesep;
    
    contest_options1(term, TEXT(T_CONTEST_OP), (void *)42);
#ifdef HAVE_SDL 
    gfx_update_qth();
#endif  
}
                               

/******************** CONTEST DEFAULTS *******************************/

/*
char tname[MAX_STR_LEN],pcall[MAX_STR_LEN],pclub[MAX_STR_LEN];
char pwwlo[MAX_STR_LEN],pexch[MAX_STR_LEN];
char default_rst[MAX_STR_LEN],default_rs[MAX_STR_LEN];
*/  
char padr1[MAX_STR_LEN],padr2[MAX_STR_LEN];

void refresh_contest_def(void *xxx)
{
/*    dbg("refresh_contest_def\n");*/
    STORE_STR(cfg,pcall);
    STORE_STR(cfg,pclub);
    STORE_STR(cfg,pwwlo);
    STORE_STR(cfg,padr1);
    STORE_STR(cfg,padr2);
    STORE_STR(cfg,pexch);
    STORE_STR(cfg,default_rs);
    STORE_STR(cfg,default_rst);
#ifdef HAVE_SDL
    gfx_update_qth();
#endif
}

char *contest_def_msg[] = {
    CTEXT(T_CALLSIGN2),  /* 0 */
    CTEXT(T_CLUB),
    CTEXT(T_YOURWWL),
    CTEXT(T_PADR1),
    CTEXT(T_PADR2),
    CTEXT(T_YOUREXC),  /* 5 */
    CTEXT(T_RS),
    CTEXT(T_RST),  
    "", /* OK */        /* 8 */
    "", /* Cancel */
};
void contest_def_fn(struct dialog_data *dlg)
{
    struct terminal *term = dlg->win->term;
    int max = 0, min = 0;
    int w, rw;
    int y = -1;

    max_group_width(term, contest_def_msg + 0, dlg->items + 0, 1, &max);
    min_group_width(term, contest_def_msg + 0, dlg->items + 0, 1, &min);
    max_group_width(term, contest_def_msg + 1, dlg->items + 1, 1, &max);
    min_group_width(term, contest_def_msg + 1, dlg->items + 1, 1, &min);
    max_group_width(term, contest_def_msg + 2, dlg->items + 2, 1, &max);
    min_group_width(term, contest_def_msg + 2, dlg->items + 2, 1, &min);
    max_group_width(term, contest_def_msg + 3, dlg->items + 3, 1, &max);
    min_group_width(term, contest_def_msg + 3, dlg->items + 3, 1, &min);
    max_group_width(term, contest_def_msg + 4, dlg->items + 4, 1, &max);
    min_group_width(term, contest_def_msg + 4, dlg->items + 4, 1, &min);
    max_group_width(term, contest_def_msg + 5, dlg->items + 5, 1, &max);
    min_group_width(term, contest_def_msg + 5, dlg->items + 5, 1, &min);
    max_group_width(term, contest_def_msg + 6, dlg->items + 6, 1, &max);
    min_group_width(term, contest_def_msg + 6, dlg->items + 6, 1, &min);
    max_group_width(term, contest_def_msg + 7, dlg->items + 7, 1, &max);
    min_group_width(term, contest_def_msg + 7, dlg->items + 7, 1, &min);
    
    max_buttons_width(term, dlg->items + 8, 2, &max);
    min_buttons_width(term, dlg->items + 8, 2, &min);
    
    w = dlg->win->term->x * 9 / 10 - 2 * DIALOG_LB;
    if (w > max) w = max;
    if (w < min) w = min;
    if (w > dlg->win->term->x - 2 * DIALOG_LB) w = dlg->win->term->x - 2 * DIALOG_LB;
    if (w < 1) w = 1;
    
    rw = 0;
    y ++;
    dlg_format_group(NULL, term, contest_def_msg + 0, dlg->items + 0, 1, 0, &y, w, &rw);
    dlg_format_group(NULL, term, contest_def_msg + 1, dlg->items + 1, 1, 0, &y, w, &rw);
    dlg_format_group(NULL, term, contest_def_msg + 2, dlg->items + 2, 1, 0, &y, w, &rw);
    dlg_format_group(NULL, term, contest_def_msg + 3, dlg->items + 3, 1, 0, &y, w, &rw);
    dlg_format_group(NULL, term, contest_def_msg + 4, dlg->items + 4, 1, 0, &y, w, &rw);
    dlg_format_group(NULL, term, contest_def_msg + 5, dlg->items + 5, 1, 0, &y, w, &rw);
    dlg_format_group(NULL, term, contest_def_msg + 6, dlg->items + 6, 1, 0, &y, w, &rw);
    dlg_format_group(NULL, term, contest_def_msg + 7, dlg->items + 7, 1, 0, &y, w, &rw);
    y++;
    dlg_format_buttons(NULL, term, dlg->items +8, 2, 0, &y, w, &rw, AL_LEFT);
    
    
    w = rw;
    dlg->xw = w + 2 * DIALOG_LB;
    dlg->yw = y + 2 * DIALOG_TB;

    
    center_dlg(dlg);
    draw_dlg(dlg);
    y = dlg->y + DIALOG_TB;
    y++;
    dlg_format_group(term, term, contest_def_msg + 0, dlg->items + 0, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group(term, term, contest_def_msg + 1, dlg->items + 1, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group(term, term, contest_def_msg + 2, dlg->items + 2, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group(term, term, contest_def_msg + 3, dlg->items + 3, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group(term, term, contest_def_msg + 4, dlg->items + 4, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group(term, term, contest_def_msg + 5, dlg->items + 5, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group(term, term, contest_def_msg + 6, dlg->items + 6, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group(term, term, contest_def_msg + 7, dlg->items + 7, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    y++;
    dlg_format_buttons(term, term, dlg->items +8, 2, dlg->x + DIALOG_LB, &y, w, NULL, AL_LEFT);
    
}



void contest_def(struct terminal *term, void *xxx, void *yyy)
{
    struct dialog *d;
    int i;

    safe_strncpy0(pcall,cfg->pcall,MAX_STR_LEN); uc(pcall);
    safe_strncpy0(pclub,cfg->pclub,MAX_STR_LEN); uc(pclub);
    safe_strncpy0(pwwlo,cfg->pwwlo,MAX_STR_LEN); uc(pwwlo);
    safe_strncpy0(padr1,cfg->padr1,MAX_STR_LEN);
    safe_strncpy0(padr2,cfg->padr2,MAX_STR_LEN);
    safe_strncpy0(pexch,cfg->pexch,MAX_STR_LEN);
    safe_strncpy0(default_rs, cfg->default_rs,MAX_STR_LEN);  uc(default_rs);
    safe_strncpy0(default_rst,cfg->default_rst,MAX_STR_LEN); uc(default_rst);
    

    if (!(d = mem_alloc(sizeof(struct dialog) + 20 * sizeof(struct dialog_item)))) return;
    memset(d, 0, sizeof(struct dialog) + 20 * sizeof(struct dialog_item));
    d->title = TEXT(T_CTEST_DEF);
    d->fn = contest_def_fn;
    d->refresh = (void (*)(void *))refresh_contest_def;
    

    d->items[i=0].type = D_FIELD;
    d->items[i].dlen = MAX_STR_LEN;
    d->items[i].data = pcall;
    d->items[i].maxl = 15;
    
    d->items[i=1].type = D_FIELD;
    d->items[i].dlen = MAX_STR_LEN;
    d->items[i].data = pclub;
    d->items[i].maxl = 15;
    
    d->items[i=2].type = D_FIELD;
    d->items[i].dlen = MAX_STR_LEN;
    d->items[i].data = pwwlo;
    d->items[i].maxl = 15;
    
    d->items[i=3].type = D_FIELD;
    d->items[i].dlen = MAX_STR_LEN;
    d->items[i].data = padr1;
    d->items[i].maxl = 25;
    
    d->items[i=4].type = D_FIELD;
    d->items[i].dlen = MAX_STR_LEN;
    d->items[i].data = padr2;
    d->items[i].maxl = 25;
    
    d->items[i=5].type = D_FIELD;
    d->items[i].dlen = MAX_STR_LEN;
    d->items[i].data = pexch;
    d->items[i].maxl = 15;
    
    d->items[i=6].type = D_FIELD;
    d->items[i].dlen = MAX_STR_LEN;
    d->items[i].data = default_rs;
    d->items[i].maxl = 5;
    
    d->items[i=7].type = D_FIELD;
    d->items[i].dlen = MAX_STR_LEN;
    d->items[i].data = default_rst;
    d->items[i].maxl = 5;
    
    d->items[++i].type = D_BUTTON;
    d->items[i].gid = B_ENTER;
    d->items[i].fn = ok_dialog;
    d->items[i].text = TEXT(T_OK);
    
    d->items[++i].type = D_BUTTON;
    d->items[i].gid = B_ESC;
    d->items[i].fn = cancel_dialog;
    d->items[i].text = TEXT(T_CANCEL);
    
    d->items[++i].type = D_END;
    do_dialog_(term, d, getml(d, NULL));
}
                               

/******************** EDI PROPERTIES *******************************/

/*
char padr1[MAX_STR_LEN],padr2[MAX_STR_LEN];
*/

void refresh_edi_prop(void *xxx)
{
/*    dbg("refresh_edi_prop\n");*/
    STORE_STR(cfg,padr1);
    STORE_STR(cfg,padr2);
}

char *edi_prop_msg[] = {
    CTEXT(T_PADR1),
    CTEXT(T_PADR2),
    "", /* OK */        /* 2 */
    "", /* Cancel */
};
void edi_prop_fn(struct dialog_data *dlg)
{
    struct terminal *term = dlg->win->term;
    int max = 0, min = 0;
    int w, rw;
    int y = -1;

    max_group_width(term, edi_prop_msg + 0, dlg->items + 0, 1, &max);
    min_group_width(term, edi_prop_msg + 0, dlg->items + 0, 1, &min);
    max_group_width(term, edi_prop_msg + 1, dlg->items + 1, 1, &max);
    min_group_width(term, edi_prop_msg + 1, dlg->items + 1, 1, &min);
    
    max_buttons_width(term, dlg->items + 2, 2, &max);
    min_buttons_width(term, dlg->items + 2, 2, &min);
    
    w = dlg->win->term->x * 9 / 10 - 2 * DIALOG_LB;
    if (w > max) w = max;
    if (w < min) w = min;
    if (w > dlg->win->term->x - 2 * DIALOG_LB) w = dlg->win->term->x - 2 * DIALOG_LB;
    if (w < 1) w = 1;
    
    rw = 0;
    y ++;
    dlg_format_group(NULL, term, edi_prop_msg + 0, dlg->items + 0, 1, 0, &y, w, &rw);
    dlg_format_group(NULL, term, edi_prop_msg + 1, dlg->items + 1, 1, 0, &y, w, &rw);
    y++;
    dlg_format_buttons(NULL, term, dlg->items +2, 2, 0, &y, w, &rw, AL_LEFT);
    
    
    w = rw;
    dlg->xw = w + 2 * DIALOG_LB;
    dlg->yw = y + 2 * DIALOG_TB;

    
    center_dlg(dlg);
    draw_dlg(dlg);
    y = dlg->y + DIALOG_TB;
    y++;
    dlg_format_group(term, term, edi_prop_msg + 0, dlg->items + 0, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group(term, term, edi_prop_msg + 1, dlg->items + 1, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    y++;
    dlg_format_buttons(term, term, dlg->items +2, 2, dlg->x + DIALOG_LB, &y, w, NULL, AL_LEFT);
    
}


void edi_prop(struct terminal *term, void *xxx, void *yyy)
{
    struct dialog *d;
    int i;

    safe_strncpy0(padr1,cfg->padr1,MAX_STR_LEN);
    safe_strncpy0(padr2,cfg->padr2,MAX_STR_LEN);
    

    if (!(d = mem_alloc(sizeof(struct dialog) + 20 * sizeof(struct dialog_item)))) return;
    memset(d, 0, sizeof(struct dialog) + 20 * sizeof(struct dialog_item));
    d->title = TEXT(T_CTEST_DEF);
    d->fn = edi_prop_fn;
    d->refresh = (void (*)(void *))refresh_edi_prop;
    

    d->items[i=0].type = D_FIELD;
    d->items[i].dlen = MAX_STR_LEN;
    d->items[i].data = padr1;
    d->items[i].maxl = 25;
    
    d->items[i=1].type = D_FIELD;
    d->items[i].dlen = MAX_STR_LEN;
    d->items[i].data = padr2;
    d->items[i].maxl = 25;
    
    d->items[++i].type = D_BUTTON;
    d->items[i].gid = B_ENTER;
    d->items[i].fn = ok_dialog;
    d->items[i].text = TEXT(T_OK);
    
    d->items[++i].type = D_BUTTON;
    d->items[i].gid = B_ESC;
    d->items[i].fn = cancel_dialog;
    d->items[i].text = TEXT(T_CANCEL);
    
    d->items[++i].type = D_END;
    do_dialog_(term, d, getml(d, NULL));
}
                               
int dlg_edi_prop(struct dialog_data *dlg, struct dialog_item_data *di){
    edi_prop(dlg->win->term, NULL, NULL); 
    return 0;
}

