/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
/*
 * FlagIconImageFactory.java
 * 
 * Created on November 26, 2001, 8:27 PM
 */
package games.strategy.triplea.image;

import games.strategy.engine.data.PlayerID;

import java.awt.Image;

/**
 * 
 * @author Sean Bridges
 * @version 1.0
 */
public class FlagIconImageFactory extends ImageFactory
{
	public static final int FLAG_ICON_WIDTH = 30;
	public static final int FLAG_ICON_HEIGHT = 15;
	public static final int SMALL_FLAG_ICON_WIDTH = 12;
	public static final int SMALL_FLAG_ICON_HEIGHT = 7;
	private final String PREFIX = "flags/";
	
	/** Creates new IconImageFactory */
	public FlagIconImageFactory()
	{
	}
	
	public Image getFlag(final PlayerID id)
	{
		final String key = PREFIX + id.getName() + ".gif";
		final String key2 = PREFIX + id.getName() + ".png";
		return getImage(key, key2, true);
	}
	
	public Image getSmallFlag(final PlayerID id)
	{
		final String key = PREFIX + id.getName() + "_small.gif";
		final String key2 = PREFIX + id.getName() + "_small.png";
		return getImage(key, key2, true);
	}
	
	public Image getLargeFlag(final PlayerID id)
	{
		final String key = PREFIX + id.getName() + "_large.png";
		return getImage(key, true);
	}
	
	public Image getFadedFlag(final PlayerID id)
	{
		final String key = PREFIX + id.getName() + "_fade.gif";
		final String key2 = PREFIX + id.getName() + "_fade.png";
		return getImage(key, key2, true);
	}
	
	public Image getConvoyFlag(final PlayerID id)
	{
		final String key = PREFIX + id.getName() + "_convoy.gif";
		final String key2 = PREFIX + id.getName() + "_convoy.png";
		return getImage(key, key2, true);
	}
}
