#!/bin/bash
#
# This script is used to setup the cluster enviroment
#
# It will create a directory <peer-directory> and populate it with N
# directories in the form of (peer-00001, peer-00002, peer-00003,
# etc).  Each of these directories will contain a directory data which
# includes the following file:
#
# - peers: a list of all peers as generated by ec-generator.py
# - peer.conf: configuration file of the node in that directory. The
#   format is similar to the peers file but only one line is include here
# - bartercast.log: a list of barter actions to perform, as generated
#   by scenario builder
# - availability.log: a list of availability actions to perform, as generated
#   by scenario builder
#
# The final structure will look like this
#
# - <peer-directory>
# |__ peer-00001/
# |__ peer-00002/
# |____ data/
# |______ peers
# |______ peer.conf
# |______ bartercast.log
# |______ availability.log
# |__ peer-00003/
# |__ ../
# |__ peer-N/


if test $# -ne 2; then
	echo "Usage: $0 <scenario-directory> <peer-directory>"
	exit 1
fi

PATH_TO_SCENARIOS=$1
PEERS_DIRECTORY=$2
NUMBER_OF_PEERS=$(find $PATH_TO_SCENARIOS -mindepth 1 -maxdepth 1 -regextype posix-egrep -regex '.*/peer-[0-9]{5}' -type d | wc -l)

echo "* Peers count: $NUMBER_OF_PEERS"

if [ -d $PEERS_DIRECTORY ]; then
    rm -rf $PEERS_DIRECTORY
fi
mkdir $PEERS_DIRECTORY


export PYTHONPATH=${BRANCH}:/home/mbardac/3rd-party/lib/python2.6/site-packages:$PYTHONPATH
export LD_LIBRARY_PATH=/home/mbardac/3rd-party/lib:$LD_LIBRARY_PATH

./barter-ec-generator.py --total-peers $NUMBER_OF_PEERS -o $PEERS_DIRECTORY/peer-keys

for i in `seq -f "%05g" $NUMBER_OF_PEERS`; do
    PEER_DATA_DIR=$PEERS_DIRECTORY/$i/data/
    mkdir -p $PEER_DATA_DIR
    cp $PEERS_DIRECTORY/peer-keys $PEER_DATA_DIR
    mv $PATH_TO_SCENARIOS/peer-$i/*.log $PEER_DATA_DIR
    head -n $i $PEERS_DIRECTORY/peer-keys | tail -n 1 > $PEER_DATA_DIR/peer.init
done



echo $NUMBER_OF_PEERS > $PEERS_DIRECTORY/peer.count

echo "Removing scenario directory (${PATH_TO_SCENARIOS})..."
rm -rf $PATH_TO_SCENARIOS/
echo "All scenario data has been moved to the peers directory (${PEERS_DIRECTORY})."

