/*****************************************************************************
    TRAVIS - Trajectory Analyzer and Visualizer
    Copyright (C) 2009-2012 Martin Brehm

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*****************************************************************************/

#include "xstring.h"

CxString operator + (const char *s1, const CxString& s2)
{
#ifdef DEBUG_CxString
	mprintf("@ operator + (const char *, const CxString &): \"%s\", \"%s\"...",s1,(const char*)s2);
#endif
	return CxString(s1,s2);
}

CxString::CxString()
{
	BXIN;
#ifdef DEBUG_CxString
	mprintf("@ CxString::CxString()\n");
#endif
	m_pData = NULL;
	BXOUT;
}
	
CxString::~CxString()
{
	BXIN;
#ifdef DEBUG_CxString
	mprintf("@ CxString::~CxString(): \"%s\"...",m_pData);
#endif
	if (m_pData != NULL)
		delete[] m_pData;
#ifdef DEBUG_CxString
	mprintf("done.\n");
#endif
	BXOUT;
}
	
CxString::CxString(const char *s)
{
	BXIN;
#ifdef DEBUG_CxString
	mprintf("@ CxString::CxString(const char *): \"%s\"...",s);
#endif

	try { m_pData = new char[strlen(s)+1]; } catch(...) { m_pData = NULL; }
	if (m_pData == NULL) NewException((double)(strlen(s)+1)*sizeof(char),__FILE__,__LINE__,__PRETTY_FUNCTION__);
	
	strcpy(m_pData,s);
#ifdef DEBUG_CxString
	mprintf("done.\n");
#endif
	BXOUT;
}
	
CxString::CxString(const CxString &s)
{
	BXIN;
#ifdef DEBUG_CxString
	mprintf("@ CxString::CxString(const CxString &): \"%s\"...",(const char*)s);
#endif

	try { m_pData = new char[s.GetLength()+1]; } catch(...) { m_pData = NULL; }
	if (m_pData == NULL) NewException((double)(s.GetLength()+1)*sizeof(char),__FILE__,__LINE__,__PRETTY_FUNCTION__);
	
	strcpy(m_pData,s.m_pData);
#ifdef DEBUG_CxString
	mprintf("done.\n");
#endif
	BXOUT;
}
	
CxString::CxString(const CxString &s1, const CxString &s2)
{
	BXIN;
#ifdef DEBUG_CxString
	mprintf("@ CxString::CxString(const CxString &, const CxString &): \"%s\", \"%s\"...",(const char*)s1,(const char*)s2);
#endif

	try { m_pData = new char[s1.GetLength()+s2.GetLength()+1]; } catch(...) { m_pData = NULL; }
	if (m_pData == NULL) NewException((double)(s1.GetLength()+s2.GetLength()+1)*sizeof(char),__FILE__,__LINE__,__PRETTY_FUNCTION__);
	
	strcpy(m_pData,s1.m_pData);
	strcat(m_pData,s2.m_pData);
#ifdef DEBUG_CxString
	mprintf("done.\n");
#endif
	BXOUT;
}
	
CxString::operator const char*() const
{
#ifdef DEBUG_CxString
	mprintf("@ CxString::operator const char* () const: \"%s\"\n",m_pData);
#endif
	return m_pData;
}
	
CxString CxString::operator + (const CxString &s) const
{
#ifdef DEBUG_CxString
	mprintf("@ CxString::operator + (const CxString &) const: \"%s\", \"%s\"\n",m_pData,(const char*)s);
#endif
	return CxString(*this,s);
}
	
bool CxString::operator == (const CxString &s) const
{
	BXIN;
#ifdef DEBUG_CxString
	mprintf("@ CxString::operator == (const CxString &) const: \"%s\", \"%s\"\n",m_pData,(const char*)s);
#endif
	if (strcmp(m_pData,s.m_pData) == 0)
	{
		BXOUT;
		return true;
	} else
	{
		BXOUT;
		return false;
	}
}
	
bool CxString::operator != (const CxString &s) const
{
	BXIN;
#ifdef DEBUG_CxString
	mprintf("@ CxString::operator != (const CxString &) const: \"%s\", \"%s\"\n",m_pData,(const char*)s);
#endif
	if (strcmp(m_pData,s.m_pData) == 0)
	{
		BXOUT;
		return false;
	} else
	{
		BXOUT;
		return true;
	}
}
	
bool CxString::operator > (const CxString &s) const
{
	BXIN;
#ifdef DEBUG_CxString
	mprintf("@ CxString::operator > (const CxString &) const: \"%s\", \"%s\"\n",m_pData,(const char*)s);
#endif
	if (strcmp(m_pData,s.m_pData) > 0)
	{
		BXOUT;
		return true;
	} else
	{
		BXOUT;
		return false;
	}	
}
	
bool CxString::operator < (const CxString &s) const
{
	BXIN;
#ifdef DEBUG_CxString
	mprintf("@ CxString::operator < (const CxString &) const: \"%s\", \"%s\"\n",m_pData,(const char*)s);
#endif
	if (strcmp(m_pData,s.m_pData) < 0)
	{
		BXOUT;
		return true;
	} else
	{
		BXOUT;
		return false;
	}
}
	
bool CxString::operator >= (const CxString &s) const
{
	BXIN;
#ifdef DEBUG_CxString
	mprintf("@ CxString::operator >= (const CxString &) const: \"%s\", \"%s\"\n",m_pData,(const char*)s);
#endif
	if (strcmp(m_pData,s.m_pData) >= 0)
	{
		BXOUT;
		return true;
	} else
	{
		BXOUT;
		return false;
	}
}
	
bool CxString::operator <= (const CxString &s) const
{
	BXIN;
#ifdef DEBUG_CxString
	mprintf("@ CxString::operator <= (const CxString &) const: \"%s\", \"%s\"\n",m_pData,(const char*)s);
#endif
	if (strcmp(m_pData,s.m_pData) <= 0)
	{
		BXOUT;
		return true;
	} else
	{
		BXOUT;
		return false;
	}
}
	
void CxString::operator += (const CxString &s)
{
	BXIN;
#ifdef DEBUG_CxString
	mprintf("@ CxString::operator += (const CxString &): \"%s\", \"%s\"...",m_pData,(const char*)s);
#endif
	strcat(m_pData,s.m_pData);
#ifdef DEBUG_CxString
	mprintf("done.\n");
#endif
	BXOUT;
}
	
char& CxString::operator [] (int i)
{
#ifdef DEBUG_CxString
	mprintf("@ CxString::operator [] (int i): \"%s\", %d\n",m_pData,i);
#endif
	return m_pData[i];
}
	
int CxString::GetLength() const
{
#ifdef DEBUG_CxString
	mprintf("@ CxString::GetLength() const: \"%s\", %d\n",m_pData,strlen(m_pData));
#endif
	return strlen(m_pData);
}
	
int CxString::FindFirst(char c) const
{
	BXIN;
#ifdef DEBUG_CxString
	mprintf("@ CxString::FindFirst(char) const: \"%s\", '%c'\n",m_pData,c);
#endif
	char *p;
	p = strchr(m_pData,c);
	if (p == NULL)
	{
		BXOUT;
		return -1;
	}
	BXOUT;
	return p-m_pData;
}	
	
int CxString::FindNext(int i, char c) const
{
	BXIN;
#ifdef DEBUG_CxString
	mprintf("@ CxString::FindNext(int, char) const: \"%s\", %d, '%c'\n",m_pData,i,c);
#endif
	char *p;
	p = strchr(&m_pData[i],c);
	if (p == NULL)
	{
		BXOUT;
		return -1;
	}
	BXOUT;
	return p-m_pData;
}	
	
int CxString::FindLast(char c) const
{
	BXIN;
#ifdef DEBUG_CxString
	mprintf("@ CxString::FindLast(char) const: \"%s\", '%c'\n",m_pData,c);
#endif
	char *p;
	p = strrchr(m_pData,c);
	if (p == NULL)
	{
		BXOUT;
		return -1;
	}
	BXOUT;
	return p-m_pData;
}
	
CxString CxString::Mid(int pos, int count) const
{
	BXIN;
	char *buf;
		
	try { buf = new char[count+1]; } catch(...) { buf = NULL; }
	if (buf == NULL) NewException((double)(count+1)*sizeof(char),__FILE__,__LINE__,__PRETTY_FUNCTION__);
	
#ifdef DEBUG_CxString
	mprintf("@ CxString::Mid(int, int) const: \"%s\", %d, %d...",m_pData,pos,count);
#endif
	memcpy(buf,&m_pData[pos],count);
	buf[count] = 0;
#ifdef DEBUG_CxString
	mprintf("done: \"%s\"\n",buf);
#endif
	CxString s = CxString(buf);
	delete[] buf;
	BXOUT;
	return s;
}
	
CxString CxString::Mid(int pos) const
{
	BXIN;
	char *buf;
		
	try { buf = new char[strlen(&m_pData[pos])+1]; } catch(...) { buf = NULL; }
	if (buf == NULL) NewException((double)(strlen(&m_pData[pos])+1)*sizeof(char),__FILE__,__LINE__,__PRETTY_FUNCTION__);
	
#ifdef DEBUG_CxString
	mprintf("@ CxString::Mid(int) const: \"%s\", %d...",m_pData,pos);
#endif
	memcpy(buf,&m_pData[pos],strlen(&m_pData[pos])+1);
#ifdef DEBUG_CxString
	mprintf("done: \"%s\"\n",buf);
#endif
	CxString s = CxString(buf);
	delete[] buf;
	BXOUT;
	return s;
}
	
CxString CxString::Left(int count) const
{
	BXIN;
	char *buf;

	try { buf = new char[count+1]; } catch(...) { buf = NULL; }
	if (buf == NULL) NewException((double)(count+1)*sizeof(char),__FILE__,__LINE__,__PRETTY_FUNCTION__);
	
#ifdef DEBUG_CxString
	mprintf("@ CxString::Left(int) const: \"%s\", %d...",m_pData,count);
#endif
	memcpy(buf,m_pData,count);
	buf[count] = 0;
#ifdef DEBUG_CxString
	mprintf("done: \"%s\"\n",buf);
#endif
	CxString s = CxString(buf);
	delete[] buf;
	BXOUT;
	return s;
}
	
void CxString::Format(const char *s, ...)
{
	BXIN;
#ifdef DEBUG_CxString
	mprintf("@ CxString::Format(const char *s): \"%s\"...",s);
#endif
	va_list params; 
	char buf[256];
	va_start(params, s); 
	vsprintf(buf,s,params);
	va_end(params);
	if (m_pData != NULL)
		delete[] m_pData;

	try { m_pData = new char[strlen(buf)+1]; } catch(...) { m_pData = NULL; }
	if (m_pData == NULL) NewException((double)(strlen(buf)+1)*sizeof(char),__FILE__,__LINE__,__PRETTY_FUNCTION__);
	
	strcpy(m_pData,buf);
#ifdef DEBUG_CxString
	mprintf("done.\n");
#endif
	BXOUT;
}
	
void CxString::Dump()
{
	BXIN;
	mprintf(m_pData);
	BXOUT;
}
