# Copyright (C) 2006 Panometrics, Inc.
# All rights reserved.
#
# This software may be used and distributed according to the terms
# of the GNU General Public License, incorporated herein by reference.

from bzrlib import conflicts
from bzrlib.tests import treeshape

from tracbzr import tests

class TestNode(tests.TracTestCase):

    def commit_foo_bar_baz(self):
        """Create an interesting merge history"""
        treeshape.build_tree_contents([('repo/tree/a/',), ('repo/tree/a/b', 
                                        'contents of b')])
        self.tree.add(['a', 'a/b'])
        self.tree.commit('tree contents', rev_id='foo%bar')
        other = self.tree.bzrdir.sprout('repo/other').open_workingtree()
        treeshape.build_tree_contents([
            ('repo/other/a/b', 'new contents of b'),
            ('repo/other/a/c', 'contents of c')])
        other.add(['a/c'])
        other.commit('added c, changed b', rev_id='baz')
        self.tree.merge_from_branch(other.branch)
        self.tree.commit('merged from other', rev_id='qux')
        self.tree.commit('empty commit', rev_id='quxx')
        treeshape.build_tree_contents([
            ('repo/tree/a/b', 'b_tree')])
        self.tree.commit('changed b', rev_id='quxxx')
        treeshape.build_tree_contents([
            ('repo/other/a/b', 'new again')])
        other.commit('changed b')
        self.tree.merge_from_branch(other.branch)
        treeshape.build_tree_contents([
            ('repo/tree/a/b', 'b_tree')])
        self.tree.set_conflicts(conflicts.ConflictList([]))
        return self.tree.commit('resolved in favour of tree', rev_id='quxxxx')
         
    def test_get_history(self):
        self.commit_foo_bar_baz()
        repo = self.trac_repo()
        node = repo.get_node('tree/a/b')
        self.assertEqual([(u'tree/a/b', 'tree,5', 'edit'),
                          (u'tree/a/b', 'tree,4', 'edit'),
                          (u'tree/a/b', 'tree,2', 'edit'),
                          (u'tree/a/b', 'tree,1', 'add')], 
                         list(node.get_history()))
        node = repo.get_node('')
        self.assertEqual([('', 'current%3A', 'add')], list(node.get_history()))

    def test_get_dir_history(self):
        self.commit_foo_bar_baz()
        repo = self.trac_repo()
        node = repo.get_node('tree/a')
        self.assertEqual([(u'tree/a', 'tree,4', 'edit'),
                          (u'tree/a', 'tree,2', 'edit'),
                          (u'tree/a', 'tree,1', 'add')], 
                         list(node.get_history()))

    def test_get_root_history(self):
        self.commit_foo_bar_baz()
        repo = self.trac_repo()
        node = repo.get_node('tree')
        self.assertEqual([(u'tree', 'tree,5', 'edit'),
                          (u'tree', 'tree,4', 'edit'),
                          (u'tree', 'tree,3', 'edit'),
                          (u'tree', 'tree,2', 'edit'),
                          (u'tree', 'tree,1', 'add')], 
                         list(node.get_history()))
