import os
from os import path
from shutil import rmtree
from tempfile import mkdtemp

from bzrlib import bzrdir, tests

from tracbzr import backend

class TracTestCase(tests.TestCase):

    def setUp(self):
        self.root = mkdtemp(prefix='trac+bzr-')
        self.old_cwd = os.getcwd()
        os.chdir(self.root)
        self.repo_root = path.join(self.root, 'repo')
        os.mkdir(self.repo_root)
        self.repo = bzrdir.BzrDir.create_repository(self.root, shared=True)
        self.treedir = path.join(self.repo_root, 'tree')
        self.tree = bzrdir.BzrDir.create_branch_convenience(self.treedir,
            force_new_tree=True).bzrdir.open_workingtree()

    def trac_repo(self):
        return backend.BzrRepository(self.repo_root, None)

    def tearDown(self):
        os.chdir(self.old_cwd)
        rmtree(self.root)
