#include "tra.h"

static void
qin(void *a)
{
	Queue *q;
	Syncpath *s;

	q = a;
	for(;;){
		s = recvp(q->in);
		if(q->s==nil)
			q->es = &q->s;
		s->nextq = nil;
		*q->es = s;
		q->es = &s->nextq;
		q->n++;
		if(q->n > q->m)
			q->m = q->n;
		if(q->waiter){
			threadready(q->waiter);
			q->waiter = nil;
		}
	}
}

static void
qout(void *a)
{
	Queue *q;
	Syncpath *s;

	q = a;
	for(;;){
		while(q->s == nil){
			q->waiter = curthread;
			threadsleep();
		}
		s = q->s;
		q->s = s->nextq;
		q->n--;
		sendp(q->out, s);
	}
}

static void
kin(void *a)
{
	Queue *q;
	Syncpath *s;

	q = a;
	for(;;){
		s = recvp(q->in);
		q->n++;
		if(q->n > q->m)
			q->m = q->n;
		s->nextq = q->s;
		q->s = s;
		if(q->waiter){
			threadready(q->waiter);
			q->waiter = nil;
		}
	}
}

static void
kout(void *a)
{
	Queue *q;
	Syncpath *s;

	q = a;
	for(;;){
		while(q->s == nil){
			q->waiter = curthread;
			threadsleep();
		}
		s = q->s;
		q->s = s->nextq;
		q->n--;
		sendp(q->out, s);
	}
}

Queue*
mkstack(void)
{
	Queue *q;

	q = emalloc(sizeof(Queue));
	q->in = chan(Syncpath*);
	q->out = chan(Syncpath*);
	threadcreate(kin, q);
	threadcreate(kout, q);
	return q;
}

Queue*
mkqueue(void)
{
	Queue *q;

	q = emalloc(sizeof(Queue));
	q->in = chan(Syncpath*);
	q->out = chan(Syncpath*);
	threadcreate(qin, q);
	threadcreate(qout, q);
	return q;
}

Syncpath*
qrecv(Queue *q)
{
	Syncpath *s;

	s = recvp(q->out);
	if(q->printrecv)
		q->printrecv(s);
//fprint(2, "deq %p returns %p (%P)\n", q, s, s->p);
	return s;
}

void
qsend(Queue *q, Syncpath *s)
{
//fprint(2, "enq %p gets %p (%P)\n", q, s, s->p);
	if(q->printsend)
		q->printsend(s);
	sendp(q->in, s);
}
