#include "tra.h"

int
ftruncate(int fd, vlong len)
{
	Dir d;

	if(len == 0){
		char buf[1024];
		if(fd2path(fd, buf, sizeof buf) < 0)
			return -1;
		close(fd=open(buf, OWRITE|OTRUNC));
		if(fd < 0)
			return -1;
		return 0;
	}else{
		nulldir(&d);
		d.length = len;
		if(dirfwstat(fd, &d) < 0){
			werrstr("ftruncate: %r");
			return -1;
		}
	}
	return 0;
}
