#include "tra.h"
#include <sys/param.h>
#include <signal.h>

char*
trapath(char *name)
{
	char *home;

	if(name[0] == '/'
	|| (name[0] == '.' && name[1] == '/')
	|| (name[0] == '.' && name[2] == '.' && name[3] == '/'))
		return estrdup(name);

	home = getenv("HOME");
	if(home == nil)
		sysfatal("cannot read user name");

	return esmprint("%s/.tra/%s", home, name);
}

Replica*
dialreplica(char *name)
{
	char *bin;
	int p[2], q[2];

	bin = trapath(name);
	if(access(bin, 1) < 0)
		sysfatal("access %s: %r", bin);

	if(pipe(p) < 0 || pipe(q) < 0)
		sysfatal("pipe: %r");

	signal(SIGCHLD, SIG_IGN);
	switch(fork()){
	case -1:
		sysfatal("rfork dialreplica: %r");

	case 0:
		close(p[0]);
		close(q[1]);
		dup2(q[0], 0);
		dup2(p[1], 1);
		execl(bin, name, nil);
		sysfatal("exec %s: %r", bin);

	default:
		close(q[0]);
		close(p[1]);
		break;
	}
	return fd2replica(p[0], q[1]);
}

