#include "os.h"

extern int _tas(void*);

int
canlock(Lock *l)
{
	return !_tas(&l->val);
}

void
unlock(Lock *l)
{
	l->val = 0;
}

void
lock(Lock *l)
{
	int i;

	for(i=0; i<10000; i++)
		if(canlock(l))
			return;
	for(i=0; i<1000; i++){
		if(canlock(l))
			return;
		usleep(1);
	}

	for(;;){
		if(canlock(l))
			return;
		usleep(1000);
	}
}
