/*  SynDaemon.h
 *
 *  Copyright (C) 2007, 2008  Stefan Kombrink
 *
 *  This file is part of TouchFreeze.
 *
 *  TouchFreeze is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  TouchFreeze is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with touchfreeze; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 *
 *  On Debian GNU/Linux systems, the complete text of the GNU General
 *  Public License can be found in the /usr/share/common-licenses/GPL file.
 */

#ifndef SYNDAEMON_H
#define SYNDAEMON_H

#include <QObject>
#include <QtGui>

#include <X11/Xlib.h>

class QTimer;


//
//
// TODO
//   * ignore modifier
//   * checking methods for synclient / version ...
//

class SynDaemon : public QObject
{
    Q_OBJECT

    public:
        //! creates the synaptics daemon with a parent
        SynDaemon( QObject* parent );

        //! destructor
        virtual ~SynDaemon();


        //! returns the typing delay between key presses and releases
        unsigned int delay() const;
        
        //! returns whether daemon in active or not
        bool isDaemonActive() const;

        //! checks whether there's keyboard activity
        bool hasKeyboardActivity() const;

        //! checks whether touch pad events are blocked currently or not
        bool isTouchPadActive() const;
        

    public slots:
    
        //! sets the typing delay between key presses and releases
        void setDelay( unsigned int );

        //! sets daemon active / inactive
        void setDaemonActive( bool );
        
        //! set whether touch pad events should be blocked or not
        void setTouchPadActive( bool );

        //! rollback settings (last saved ones!)
        void rollbackSettings();
        
        //! commit settings (currently set ones!)
        void commitSettings();

    signals:
        //! emitted when typing starts, ignores keyboard modifiers if set
        //! regardless whether key events are being blocked or not
        void startTyping();

        //! emitted delay seconds after the last key release event
        //! regardless whether key events are being blocked or not
        void stopTyping();

    protected:
        //! reads currect X modifiers
        void initModifiers();

    signals:
        //! triggers the bypassing of the key events
        void triggerBypass();

    protected slots:
        //! first key press event
        void onStartTyping();

        //! called after the delay has passed
        void onStopTyping();

        //! checks on keyboard activity
        void checkOnKeyboardActivity();

    private:
        //! display variable for Xlib calls
        Display* mDisplay; // FIXME

        //! for bypass typing
        QTimer mBypassTimer;
        
        //! to activate/deactivate daemon (no delaying at all)
        bool mDaemonActive;

        //! touch pad events are blocked?
        bool mTouchPadActive;

        //! for keyboard activity polling
        QTimer mPollingTimer;
};

#endif

