# Symbolic Color names

# $Id: colornames.pl,v 1.1.1.1 2004/11/24 18:25:16 ssinyagin Exp $
# Stanislav Sinyagin <ssinyagin@yahoo.com>
# Shawn Ferry <sferry at sevenspace dot com> <lalartu at obscure dot org>

my %colorNames =
    (
     # Taken from the tt2 example file
     'black'    => {'color'   => '#000000'},
     'grey25'   => {'color'   => '#404040'},
     'grey50'   => {'color'   => '#808080'},
     'grey75'   => {'color'   => '#c0c0c0'},
     'white'    => {'color'   => '#ffffff'},
     'red'      => {'color'   => '#ff0000'},
     'red25'    => {'color'   => '#400000'},
     'red50'    => {'color'   => '#800000'},
     'red75'    => {'color'   => '#c00000'},
     'green'    => {'color'   => '#00ff00'},
     'green25'  => {'color'   => '#004000'},
     'green50'  => {'color'   => '#008000'},
     'green75'  => {'color'   => '#00c000'},
     'blue'     => {'color'   => '#0000ff'},
     'blue25'   => {'color'   => '#000040'},
     'blue50'   => {'color'   => '#000080'},
     'blue75'   => {'color'   => '#0000c0'},
     'blood'    => {'color'   => '#800000'},
     'scarlet'  => {'color'   => '#c04040'},
     'rose'     => {'color'   => '#f08080'},
     'orange'   => {'color'   => '#fe7202'},
     'leaf'     => {'color'   => '#006400'},
     'bud'      => {'color'   => '#66aa66'},
     'mint'     => {'color'   => '#aaffaa'},
     'marine'   => {'color'   => '#0066cc'},
     'sky'      => {'color'   => '#66ccff'},
     'mauve'    => {'color'   => '#6666cc'},
     'lilac'    => {'color'   => '#9797ff'},

     # http://www.mandarindesign.com/color.html#namedcolors
     # http://www.w3schools.com/html/html_colornames.asp
     # http://www.oreilly.com/catalog/wdnut/excerpt/color_names.html
     'aliceblue'            => {'color'   => '#F0F8FF'},
     'antiquewhite'         => {'color'   => '#FAEBD7'},
     'aqua'                 => {'color'   => '#00FFFF'},
     'aquamarine'           => {'color'   => '#7FFFD4'},
     'azure'                => {'color'   => '#F0FFFF'},
     'beige'                => {'color'   => '#F5F5DC'},
     'bisque'               => {'color'   => '#FFE4C4'},
     'blanchedalmond'       => {'color'   => '#FFEBCD'},
     'blueviolet'           => {'color'   => '#8A2BE2'},
     'brown'                => {'color'   => '#A52A2A'},
     'burlywood'            => {'color'   => '#DEB887'},
     'cadetblue'            => {'color'   => '#5F9EA0'},
     'chartreuse'           => {'color'   => '#7FFF00'},
     'chocolate'            => {'color'   => '#D2691E'},
     'coral'                => {'color'   => '#FF7F50'},
     'cornflowerblue'       => {'color'   => '#6495ED'},
     'cornsilk'             => {'color'   => '#FFF8DC'},
     'crimson'              => {'color'   => '#DC143C'},
     'cyan'                 => {'color'   => '#00FFFF'},
     'darkblue'             => {'color'   => '#00008B'},
     'darkcyan'             => {'color'   => '#008B8B'},
     'darkgoldenrod'        => {'color'   => '#B8860B'},
     'darkgray'             => {'color'   => '#A9A9A9'},
     'darkgreen'            => {'color'   => '#006400'},
     'darkkhaki'            => {'color'   => '#BDB76B'},
     'darkmagenta'          => {'color'   => '#8B008B'},
     'darkolivegreen'       => {'color'   => '#556B2F'},
     'darkorange'           => {'color'   => '#FF8C00'},
     'darkorchid'           => {'color'   => '#9932CC'},
     'darkred'              => {'color'   => '#8B0000'},
     'darksalmon'           => {'color'   => '#E9967A'},
     'darkseagreen'         => {'color'   => '#8FBC8B'},
     'darkslateblue'        => {'color'   => '#483D8B'},
     'darkslategray'        => {'color'   => '#2F4F4F'},
     'darkturquoise'        => {'color'   => '#00CED1'},
     'darkviolet'           => {'color'   => '#9400D3'},
     'deeppink'             => {'color'   => '#FF1493'},
     'deepskyblue'          => {'color'   => '#00BFFF'},
     'dimgray'              => {'color'   => '#696969'},
     'dodgerblue'           => {'color'   => '#1E90FF'},
     'firebrick'            => {'color'   => '#B22222'},
     'floralwhite'          => {'color'   => '#FFFAF0'},
     'forestgreen'          => {'color'   => '#228B22'},
     'fuchsia'              => {'color'   => '#FF00FF'},
     'gainsboro'            => {'color'   => '#DCDCDC'},
     'ghostwhite'           => {'color'   => '#F8F8FF'},
     'gold'                 => {'color'   => '#FFD700'},
     'goldenrod'            => {'color'   => '#DAA520'},
     'gray'                 => {'color'   => '#808080'},
     'greenyellow'          => {'color'   => '#ADFF2F'},
     'honeydew'             => {'color'   => '#F0FFF0'},
     'hotpink'              => {'color'   => '#FF69B4'},
     'indianred'            => {'color'   => '#CD5C5C'},
     'indigo'               => {'color'   => '#4B0082'},
     'ivory'                => {'color'   => '#FFFFF0'},
     'khaki'                => {'color'   => '#F0E68C'},
     'lavender'             => {'color'   => '#E6E6FA'},
     'lavenderblush'        => {'color'   => '#FFF0F5'},
     'lawngreen'            => {'color'   => '#7CFC00'},
     'lemonchiffon'         => {'color'   => '#FFFACD'},
     'lightblue'            => {'color'   => '#ADD8E6'},
     'lightcoral'           => {'color'   => '#F08080'},
     'lightcyan'            => {'color'   => '#E0FFFF'},
     'lightgoldenrodyellow' => {'color'   => '#FAFAD2'},
     'lightgreen'           => {'color'   => '#90EE90'},
     'lightgrey'            => {'color'   => '#D3D3D3'},
     'lightpink'            => {'color'   => '#FFB6C1'},
     'lightsalmon'          => {'color'   => '#FFA07A'},
     'lightseagreen'        => {'color'   => '#20B2AA'},
     'lightskyblue'         => {'color'   => '#87CEFA'},
     'lightslategray'       => {'color'   => '#778899'},
     'lightsteelblue'       => {'color'   => '#B0C4DE'},
     'lightyellow'          => {'color'   => '#FFFFE0'},
     'lime'                 => {'color'   => '#00FF00'},
     'limegreen'            => {'color'   => '#32CD32'},
     'linen'                => {'color'   => '#FAF0E6'},
     'magenta'              => {'color'   => '#FF00FF'},
     'maroon'               => {'color'   => '#800000'},
     'mediumaquamarine'     => {'color'   => '#66CDAA'},
     'mediumblue'           => {'color'   => '#0000CD'},
     'mediumorchid'         => {'color'   => '#BA55D3'},
     'mediumpurple'         => {'color'   => '#9370DB'},
     'mediumseagreen'       => {'color'   => '#3CB371'},
     'mediumslateblue'      => {'color'   => '#7B68EE'},
     'mediumspringgreen'    => {'color'   => '#00FA9A'},
     'mediumturquoise'      => {'color'   => '#48D1CC'},
     'mediumvioletred'      => {'color'   => '#C71585'},
     'midnightblue'         => {'color'   => '#191970'},
     'mintcream'            => {'color'   => '#F5FFFA'},
     'mistyrose'            => {'color'   => '#FFE4E1'},
     'moccasin'             => {'color'   => '#FFE4B5'},
     'navajowhite'          => {'color'   => '#FFDEAD'},
     'navy'                 => {'color'   => '#000080'},
     'oldlace'              => {'color'   => '#FDF5E6'},
     'olive'                => {'color'   => '#808000'},
     'olivedrab'            => {'color'   => '#6B8E23'},
     'orangered'            => {'color'   => '#FF4500'},
     'orchid'               => {'color'   => '#DA70D6'},
     'palegoldenrod'        => {'color'   => '#EEE8AA'},
     'palegreen'            => {'color'   => '#98FB98'},
     'paleturquoise'        => {'color'   => '#AFEEEE'},
     'palevioletred'        => {'color'   => '#DB7093'},
     'papayawhip'           => {'color'   => '#FFEFD5'},
     'peachpuff'            => {'color'   => '#FFDAB9'},
     'peru'                 => {'color'   => '#CD853F'},
     'pink'                 => {'color'   => '#FFC0CB'},
     'plum'                 => {'color'   => '#DDA0DD'},
     'powderblue'           => {'color'   => '#B0E0E6'},
     'purple'               => {'color'   => '#800080'},
     'rosybrown'            => {'color'   => '#BC8F8F'},
     'royalblue'            => {'color'   => '#4169E1'},
     'saddlebrown'          => {'color'   => '#8B4513'},
     'salmon'               => {'color'   => '#FA8072'},
     'sandybrown'           => {'color'   => '#F4A460'},
     'seagreen'             => {'color'   => '#2E8B57'},
     'seashell'             => {'color'   => '#FFF5EE'},
     'sienna'               => {'color'   => '#A0522D'},
     'silver'               => {'color'   => '#C0C0C0'},
     'skyblue'              => {'color'   => '#87CEEB'},
     'slateblue'            => {'color'   => '#6A5ACD'},
     'slategray'            => {'color'   => '#708090'},
     'snow'                 => {'color'   => '#FFFAFA'},
     'springgreen'          => {'color'   => '#00FF7F'},
     'steelblue'            => {'color'   => '#4682B4'},
     'tan'                  => {'color'   => '#D2B48C'},
     'teal'                 => {'color'   => '#008080'},
     'thistle'              => {'color'   => '#D8BFD8'},
     'tomato'               => {'color'   => '#FF6347'},
     'turquoise'            => {'color'   => '#40E0D0'},
     'violet'               => {'color'   => '#EE82EE'},
     'wheat'                => {'color'   => '#F5DEB3'},
     'whitesmoke'           => {'color'   => '#F5F5F5'},
     'yellow'               => {'color'   => '#FFFF00'},
     'yellowgreen'          => {'color'   => '#9ACD32'},
     );

while( my($style, $def) = each( %colorNames ) )
{
    $Torrus::Renderer::graphStyles{$style} = $def;
}

1;
