/*
** TleenX2 (Tlen.pl Client)
** Copyright (c) 2002-2003 Hubert Sokoowski <who_ami@tlen.pl>
**                         Pawe Biliski <rael@fr.pl>
**
** This code is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public License.
**
*/


//obsluga plikow

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <fcntl.h>
#include <errno.h>
#include <string.h>
#include <time.h>

#include <glib.h>
#include <glib/gprintf.h>

#include "main.h"
#include "conffile.h"
#include "support.h"
#include "utils.h"
#include "users.h"
#include "lista.h"
#include "groups.h"

extern int errno;

static gchar* read_line(FILE *f)
{
  gchar *s=NULL, *s2=NULL;
  gchar c;
  gsize l;

  s = g_strdup("");
  s2 = g_strdup("");
  while(1)
  {
    l = fread(&c, 1, 1, f);
    if (l != 1) {
	  g_free(s2);
	  g_free(s); 
      return NULL;
    }
    if(c == '\n')
      break;
    g_free(s2);
    s2 = g_strdup(s);
    g_free(s);
    s = g_strdup_printf("%s%c", s2, c);
  }
  g_free(s2);
  return s;
}


gchar *write_line(FILE *f, gchar *message)
{
  gchar *s=message;

  while(*s)
  {
    if((*s) == '\n')
      return ++s;
    fprintf(f,"%c",*s);
    s++;
  }
  return NULL;
}

void free_chat(struct chat *ch)
{
  g_free(ch->jid);
  g_free(ch->message);
  g_free(ch);
}


void save_info(FILE *f, const gchar *jid, gchar *message,
               gint from, struct tm tm)
{
  gchar s[21], *s2;

  if(from)
    fprintf(f,"<\n");
  else
    fprintf(f,">\n");
  fprintf(f,"%s\n",jid);
  strftime(s,20,"%d %m %Y",&tm);
  fprintf(f,"%s\n",s);
  strftime(s,20,"%H %M %S",&tm);
  fprintf(f,"%s\n",s);
  s2=message;
  while(s2)
  {
    fprintf(f,"#");
    s2=write_line(f,s2);
    fprintf(f,"\n");
  }
}

gboolean arch_too_big(const gchar *filename)
{
  struct stat buf;

  if(stat(filename,&buf))
    return FALSE;
  if(buf.st_size >= MAX_ARCH_LEN)
    return TRUE;
  return FALSE;

}

void arch_move()
{
  gchar *filename, *newfile;
  gint i;

  for(i=1;;i++)
  {
    filename=g_strdup_printf("%s/.tleenx/rozmowy.%s.%d",getenv("HOME"),
                             pname,i);
    if(!file_exists(filename))
      break;
    g_free(filename);
  }
  g_free(filename);
  while(i-->1)
  {
    filename=g_strdup_printf("%s/.tleenx/rozmowy.%s.%d",getenv("HOME"),
                             pname,i);
    newfile=g_strdup_printf("%s/.tleenx/rozmowy.%s.%d",getenv("HOME"),
                             pname,i+1);
    rename(filename,newfile);
    g_free(filename);
    g_free(newfile);
  }
  filename=g_strdup_printf("%s/.tleenx/rozmowy.%s",getenv("HOME"),
                           pname);
  newfile=g_strdup_printf("%s/.tleenx/rozmowy.%s.1",getenv("HOME"),
                          pname);
  rename(filename,newfile);
  g_free(filename);
  g_free(newfile);
}

int chat_list_flush()
{
  GList *l=chat_list;
  struct chat *ch;
  FILE *f;
  gchar *filename;

  if(!l)
    return 0;
  if(create_dir())
    return 1;
  filename=g_strdup_printf("%s/.tleenx/rozmowy.%s",getenv("HOME"),
                           pname);
  if(arch_too_big(filename))
    arch_move();
  f=fopen(filename, "a");
  if(!f)
  {
    tleenx_print(ERROR, "Nie mona utworzy pliku %s\n", filename);
    g_free(filename);
//    gtk_exit(1);
    return 2;
  }
  while(l)
  {
    ch=(struct chat*)l->data;
    save_info(f,ch->jid,ch->message,ch->from,ch->time);
    free_chat(ch);
    l=l->next;
    chat_list=g_list_remove(chat_list,(gpointer)ch);
  }
  g_list_free(chat_list);
  chat_list=NULL;
  fsync(fileno(f));
//  fflush(f);
  fclose(f);
  chmod(filename,0600);
  g_free(filename);
  return 0;
}

void queue_chat(const gchar *jid, gchar *message, gint from)
{
  struct chat *ch;
  time_t t;

  ch=(struct chat*)g_malloc(sizeof(struct chat));
  ch->jid=g_strdup(jid);
  ch->message=g_strdup(message);
  ch->from=from;
  t=time(NULL);
  localtime_r(&t,&(ch->time));
  chat_list=g_list_append(chat_list,(gpointer)ch);
  chatbuf+=strlen(message);
  if(chatbuf >= MAX_CHATBUF)
  {
    chat_list_flush();
    chatbuf=0;
  }
}

int save_message(const gchar *jid, gchar *message, gint from)
{
  FILE *f;
  gchar *filename;
  struct tm tm;
  time_t t;

  if(create_dir())
    return 1;
  filename=g_strdup_printf("%s/.tleenx/wiadomosci.%s",getenv("HOME"),
                           pname);
  f=fopen(filename, "a");
  if(!f)
  {
    tleenx_print(ERROR, "bd: nie mona utworzy pliku %s\n", filename);
    g_free(filename);
    return 2;
  }
  t=time(NULL);
  localtime_r(&t,&tm);
  save_info(f,jid,message,from,tm);
  fclose(f);
  chmod(filename,0600);
  g_free(filename);
  return 0;
}

void load_combo()
{
  GList *l=NULL, *l2=profiles_list;
  struct profile *p;
  GtkWidget *widget;
  gchar *s;

  if(l2)
  while(l2)
  {
    p=(struct profile*) l2->data;
    s = utf(p->pname);
    l=g_list_append(l,(gpointer)(s));
    l2=l2->next;
  }
  else
  {
    s = g_strdup("");
    l=g_list_append(l,(gpointer) s);
  }
  widget=lookup_widget(window_login,"combo");
  gtk_combo_set_popdown_strings (GTK_COMBO(widget),l);
  g_list_foreach(l, (GFunc )g_free, NULL);
  g_list_free(l);
}

void profile_jabber(const gchar *pname, const gchar *jserver,
                    const gchar *jlogin,
                    const gchar *jpassword,
                    const gchar *jresource)
{
  struct profile *p;

  p = get_profile(pname);
  if(!p)
    return;
  g_free(p->jserver);
  g_free(p->jlogin);
  g_free(p->jpassword);
  g_free(p->jresource);
  p->jserver = g_strdup(jserver);
  p->jlogin = g_strdup(jlogin);
  p->jpassword = g_strdup(jpassword);
  if((!jresource) || (jresource[0] == '\0'))
    p->jresource = g_strdup("jabby");
  else
    p->jresource = g_strdup(jresource);
}

void profile_gg(const gchar *pname,
                const gchar *ggnumber,
                const gchar *ggpassword)
{
  struct profile *p;

  p = get_profile(pname);
  if(!p)
    return;
  g_free(p->ggnumber);
  g_free(p->ggpassword);
  p->ggnumber = g_strdup(ggnumber);
  p->ggpassword = g_strdup(ggpassword);
}

void profile_sms(const gchar *pname,
                 const gchar *id,
                 const gchar *password)
{
  struct profile *p;

  p = get_profile(pname);
  if(!p)
    return;
  g_free(p->smsid);
  g_free(p->smspassword);
  p->smsid = g_strdup(id);
  p->smspassword = g_strdup(password);
}


void add_profile(const gchar *pname,
                 const gchar *login, const gchar *password)
{
  struct profile *p;


  if(!login || !password)
    return;
  if((login[0] == '\0') || (password[0] =='\0'))
    return;
  if(get_profile(pname))
    del_profile(pname);

  p=(struct profile *) g_malloc(sizeof(struct profile));
  memset((void*) p, 0, sizeof(*p));
  p->pname = g_strdup(pname);
  p->login = g_strdup(login);
  p->password = g_strdup(password);
  profiles_list = g_list_append(profiles_list, (gpointer) p);
}

void free_profile(struct profile *p)
{
  g_free(p->pname);
  g_free(p->login);
  g_free(p->password);
  g_free(p->jserver);
  g_free(p->jlogin);
  g_free(p->jpassword);
  g_free(p->jresource);
  g_free(p->ggnumber);
  g_free(p->ggpassword);
  g_free(p->ggserver);
  g_free(p->sms);
  g_free(p->smsid);
  g_free(p->smspassword);
  g_free(p);
}

void profiles_list_clear()
{
  struct profile *p;
  GList *l=profiles_list;
  
  while(l)
  {
    p=(struct profile*) l->data;
    free_profile(p);
    l=l->next;
  }
  g_list_free(profiles_list);
  profiles_list=NULL;
}

void goto_nextline(FILE *f)
{
  while(!feof(f))
  {
    if(fgetc(f) == '\n')
      return;
  }
}

//section jest postaci "---sekcja---\n"
int goto_section(gchar *section, FILE *f)
{
  gchar s[MAX_SNAME+8];
  while(!feof(f))
  {
    fgets(s,MAX_SNAME+6,f);
    if(!strcmp(s,"\n"))
      return 1;
    if(!strcmp(s," \n"))
      continue;
    if(!strcmp(s,section))
      return 0;
    if(s[strlen(s)-1] != '\n')
      goto_nextline(f);
  }
  return 1;
}

struct profile *get_profile(const gchar *pname)
{
  GList *l=profiles_list;
  struct profile *p;

  while(l)
  {
    p=(struct profile*) l->data;
    if(!strcmp(pname,p->pname))
      return p;
    l=l->next;
  }
  return NULL;
}

gboolean last_login()
{
  FILE *f;
  gchar *filename;
  gchar line[MAX_LLEN+1];
  gchar s[MAX_LLEN+1];

  filename=g_strdup_printf("%s/.tleenx/config",getenv("HOME"));
  f=fopen(filename,"r");
  g_free(filename);
  if(!f)
  {
    return FALSE;
  }
  if(!goto_section("---lastlogin---\n", f))
  {
    fgets(line,MAX_LLEN,f);
    sscanf(line,"%s", s);
    pname = g_strdup(s);
    fclose(f);
    return TRUE;
  }
  fclose(f);
  return FALSE;
}

void load_profiles()
{
  FILE *f;
  gchar *filename;
  gchar line[MAX_LLEN+1];
  gchar login[MAX_LLEN+1];
  gchar password[MAX_LLEN+1];
  gchar pname[MAX_LLEN+1];
  gchar jserver[MAX_LLEN+1];
  gchar jresource[MAX_LLEN+1];

  filename=g_strdup_printf("%s/.tleenx/config",getenv("HOME"));

  f=fopen(filename,"r");
  if(!f)
  {
    g_free(filename);
    return;
  }
  if(profiles_list)
    profiles_list_clear();
  if(!goto_section("---profile2---\n",f))
  while(!feof(f))
  {
    fgets(line,MAX_LLEN,f);
    if((line[0] == '\n') || !strcmp(line, " \n"))
      break;
    sscanf(line,"%s %s %s",pname, login, password);
    add_profile(pname, login, password);
  }
  else
  {
    rewind(f);
    if(!goto_section("---profile---\n",f))
      while(!feof(f))
      {
        fgets(line,MAX_LLEN,f);
        if((line[0] == '\n') || !strcmp(line, " \n"))
          break;
        sscanf(line,"%s %s",login, password);
        add_profile(login, login, password);
      }
  }
  rewind(f);
  if(!goto_section("---jabber---\n", f))
    while(!feof(f))
    {
      fgets(line, MAX_LLEN, f);
      if((line[0] == '\n') || !strcmp(line, " \n"))
        break;
      sscanf(line,"%s %s %s %s %s",pname, jserver, login, password, jresource);
      profile_jabber(pname, jserver, login, password, jresource);
    }
  rewind(f);
  if(!goto_section("---gg---\n", f))
    while(!feof(f))
    {
      fgets(line, MAX_LLEN, f);
      if((line[0] == '\n') || !strcmp(line, " \n"))
        break;
      sscanf(line,"%s %s %s", pname, login, password);
      profile_gg(pname, login, password);
    }
  rewind(f);
  if(!goto_section("---sms---\n", f))
    while(!feof(f))
    {
      fgets(line, MAX_LLEN, f);
      if((line[0] == '\n') || !strcmp(line, " \n"))
        break;
      sscanf(line,"%s %s %s", pname, login, password);
      profile_sms(pname, login, password);
    }
  fclose(f);
  g_free(filename);
}

void del_profile(const gchar *pname)
{
  GList *l=profiles_list;
  struct profile *p;

  if(!pname)
    return;
  if(pname[0] == '\0')
    return;

  while(l)
  {
    p=(struct profile *) l->data;
    if(!strcmp(p->pname,pname))
    {
      free_profile(p);
      profiles_list=g_list_remove(profiles_list, (gpointer) p);
      break;
    }
    l=l->next;
  }
}



int create_dir()
{
  gchar *dirname;
  gint retval = 0;

  dirname=g_strdup_printf("%s/.tleenx",getenv("HOME"));
  if(mkdir(dirname,0755))
  {
    switch(errno)
    {
      case EEXIST:
		retval = 0;
        break;
      default:
        tleenx_print(ERROR, "Nie mona utworzy katalogu %s\n", dirname);
        retval = 1;
        break;
    }
  }
  g_free(dirname);
  return retval;
}

int create_file()
{
  gchar *filename;
  FILE *f;
  GList *list;
  struct profile *p;

  if(create_dir())
    return 1;

  filename=g_strdup_printf("%s/.tleenx/config",getenv("HOME"));
  f=fopen(filename, "w");
  if(!f)
  {
    tleenx_print(ERROR, "Nie mona utworzy pliku %s\n", filename);
    g_free(filename);
    return 2;
  }
  fprintf(f,"plik konfiguracyjny TleenX, nie edytuj\n");
  fprintf(f,"---wersja---\n0.2\n");
  if(profiles_list)
    fprintf(f," \n---profile---\n");
  list=profiles_list;
  while(list)
  {
    p=(struct profile *) list->data;
    fprintf(f,"%s %s\n",p->login, p->password);
    list=list->next;
  }
  if(profiles_list)
    fprintf(f," \n---profile2---\n");
  list=profiles_list;
  while(list)
  {
    p=(struct profile *) list->data;
    fprintf(f,"%s %s %s\n",p->pname, p->login, p->password);
    list=list->next;
  }
  if(preferences & PREF_LASTLOGIN)
    if(pname)
    {
      fprintf(f," \n---lastlogin---\n");
      fprintf(f,"%s\n", pname);
    }
  list=profiles_list;
  fprintf(f," \n---jabber---\n");
  while(list)
  {
    p=(struct profile *) list->data;
    if((p->jserver) && (p->jlogin) && (p->jpassword) && (p->jresource))
      fprintf(f,"%s %s %s %s %s\n", p->pname, p->jserver, p->jlogin,
              p->jpassword, p->jresource);
    list=list->next;
  }
  list=profiles_list;
  fprintf(f," \n---gg---\n");
  while(list)
  {
    p=(struct profile *) list->data;
    if((p->ggnumber) && (p->ggpassword))
      fprintf(f,"%s %s %s\n", p->pname, p->ggnumber,
              p->ggpassword);
    list=list->next;
  }
  list=profiles_list;
  fprintf(f," \n---sms---\n");
  while(list)
  {
    p=(struct profile *) list->data;
    if((p->smsid) && (p->smspassword))
      fprintf(f,"%s %s %s\n", p->pname, p->smsid,
              p->smspassword);
    list=list->next;
  }
  fprintf(f,"\n");
  fclose(f);
  chmod(filename,0600);
  g_free(filename);
  return 0;
}

int save_preferences()
{
  gchar *filename;
  FILE *f;
  gint posx,posy,width,height;
  GList *l;

  filename=g_strdup_printf("%s/.tleenx/prefs.%s",getenv("HOME"),pname);
  f=fopen(filename, "w");
  if(!f)
  {
    tleenx_print(ERROR, "Nie mona utworzy pliku %s\n", filename);
    g_free(filename);
    return 2;
  }
  fprintf(f,"newmail %d\n",(preferences & PREF_NEWMAIL)?1:0);
  if(preferences & PREF_SAVESTAT)
    fprintf(f,"savestat %d\n",status);
  fprintf(f,"beeponm %d\n",(preferences & PREF_BEEPONM)?1:0);
  fprintf(f,"beepons %d\n",(preferences & PREF_BEEPONS)?1:0);
  fprintf(f,"beepona %d\n",(preferences & PREF_BEEPONA)?1:0);
  fprintf(f,"beeponn %d\n",(preferences & PREF_BEEPONN)?1:0);
  fprintf(f,"beeponw %d\n",(preferences & PREF_BEEPONW)?1:0);
  fprintf(f,"beepont %d\n",(preferences & PREF_BEEPONT)?1:0);
  fprintf(f,"enteron %d\n",(preferences & PREF_ENTERON)?1:0);
  fprintf(f,"debugon %d\n",(preferences & PREF_DEBUGON)?1:0);
  fprintf(f,"lastlogin %d\n",(preferences & PREF_LASTLOGIN)?1:0);
  fprintf(f,"autoaway %d\n",(preferences & PREF_AUTOAWAY)?1:0);
  if(preferences & PREF_AUTOAWAY)
  {
    fprintf(f,"away_min %d\n",away_min);
    fprintf(f,"away_sec %d\n",away_sec);
    fprintf(f,"ext_away_min %d\n",ext_away_min);
    fprintf(f,"ext_away_sec %d\n",ext_away_sec);
  }
  fprintf(f,"desc_num %d\n", desc_num);
  fprintf(f,"xmms_info %d\n",(preferences & PREF_XMMS_INFO)?1:0);
  fprintf(f,"hide_offline %d\n",(preferences & PREF_HIDE_OFFLINE)?1:0);
  fprintf(f,"list_expanded %d\n",(preferences & PREF_LIST_EXPANDED)?1:0);
  fprintf(f,"emots %d\n",(preferences & PREF_EMOTS)?1:0);
  if(preferences & PREF_GROUPS_NONE)
    fprintf(f,"groups %d\n",PREF_GROUPS_NONE);
  else if(preferences & PREF_GROUPS_LIST)
    fprintf(f,"groups %d\n",PREF_GROUPS_LIST);
  if(preferences & PREF_INFO_MENU)
    fprintf(f,"infomenu %d\n",1);
  gtk_window_get_position(GTK_WINDOW(window1), &posx, &posy);
  gtk_window_get_size(GTK_WINDOW(window1), &width, &height);
//  gdk_window_get_size(window1->window, &width,&height);
  fprintf(f,"positionx %d\n",posx);
  fprintf(f,"positiony %d\n",posy);
  fprintf(f,"width %d\n",width);
  fprintf(f,"height %d\n",height);
  fprintf(f,"endsection1 1\n");
  if(datefg)
    fprintf(f,"datefg %s\n",datefg);
  if(nickfg)
    fprintf(f,"nickfg %s\n",nickfg);
  if(textfg)
    fprintf(f,"textfg %s\n",textfg);
  if(textbg)
    fprintf(f,"textbg %s\n",textbg);
//  if(jabberjid)
//    fprintf(f,"jabberjid %s\n",jabberjid);
//  if(jabberpassword)
//    fprintf(f,"jabberpassword %s\n",jabberpassword);
  if(sounds[SOUNDM])
    fprintf(f,"soundm %s\n",sounds[SOUNDM]);
  if(sounds[SOUNDS])
    fprintf(f,"sounds %s\n",sounds[SOUNDS]);
  if(sounds[SOUNDA])
    fprintf(f,"sounda %s\n",sounds[SOUNDA]);
  if(sounds[SOUNDN])
    fprintf(f,"soundn %s\n",sounds[SOUNDN]);
  if(sounds[SOUNDW])
    fprintf(f,"soundw %s\n",sounds[SOUNDW]);
  if(sounds[SOUNDT])
    fprintf(f,"soundt %s\n",sounds[SOUNDT]);
  if(playpath)
    fprintf(f,"playpath %s\n",playpath);
  if(browser)
    fprintf(f,"browser %s\n",browser);
  l = desc_list;
  if(l)
    fprintf(f,"begindesc 1\n");
  posx=1;
  while(l && (posx<=desc_num))
  {
    fprintf(f,"%s\n", (gchar*) (l->data));
    posx++;
    l = l->next;
  }
  fclose(f);
  chmod(filename,0600);
  g_free(filename);
  return 0;
}

int read_preferences()
{
  gchar *filename;
  FILE *f;
  gchar var[MAX_VARNAME+1];
  gchar vals[MAX_VALLEN+1];
  gint val;
  gboolean groups_unknown=TRUE;


  preferences = 0;
  filename=g_strdup_printf("%s/.tleenx/prefs.%s",getenv("HOME"),pname);
  f=fopen(filename, "r");
  g_free(filename);
  if(!f)
  {
	tleenx_print(WARNING, "Nie mozna otworzy pliku %s\n", filename);
    preferences |= PREF_GROUPS_NONE;
    return 2;
  }
  posx=posy=width=height=0;
  while(!feof(f))
  {
    fscanf(f,"%s %d\n",var,&val);
    if(!strcmp(var,"newmail") && (val == 1))
      preferences |= PREF_NEWMAIL;
    if(!strcmp(var,"savestat"))
    {
      preferences |= PREF_SAVESTAT;
      status=val;
    }
    if(!strcmp(var,"infomenu"))
      preferences |= PREF_INFO_MENU;
    if(!strcmp(var,"beeponm") && (val == 1))
      preferences |= PREF_BEEPONM;
    if(!strcmp(var,"beepons") && (val == 1))
      preferences |= PREF_BEEPONS;
    if(!strcmp(var,"beepona") && (val == 1))
      preferences |= PREF_BEEPONA;
    if(!strcmp(var,"beeponn") && (val == 1))
      preferences |= PREF_BEEPONN;
    if(!strcmp(var,"beeponw") && (val == 1))
      preferences |= PREF_BEEPONW;
    if(!strcmp(var,"beepont") && (val == 1))
      preferences |= PREF_BEEPONT;
    if(!strcmp(var,"enteron") && (val == 1))
      preferences |= PREF_ENTERON;
    if(!strcmp(var,"lastlogin") && (val == 1))
      preferences |= PREF_LASTLOGIN;
    if(!strcmp(var,"autoaway") && (val == 1))
      preferences |= PREF_AUTOAWAY;
    if(!strcmp(var,"xmms_info") && (val == 1))
      preferences |= PREF_XMMS_INFO;
    if(!strcmp(var,"list_expanded") && (val == 1))
      preferences |= PREF_LIST_EXPANDED;
    if(!strcmp(var,"debugon") && (val == 1))
      preferences |= PREF_DEBUGON;
    if(!strcmp(var,"hide_offline") && (val == 1))
      preferences |= PREF_HIDE_OFFLINE;
    if((!strcmp(var,"emots")) && (val == 1))
      preferences |= PREF_EMOTS;
	if(!strcmp(var,"groups"))
    {
      preferences |= val;
      groups_unknown=FALSE;
    }
    if(!strcmp(var,"positionx"))
    {
      posx=val;
    }
    if(!strcmp(var,"positiony"))
    {
      posy=val;
    }
    if(!strcmp(var,"away_min"))
      away_min = val;
    if(!strcmp(var,"away_sec"))
      away_sec = val;
    if(!strcmp(var,"ext_away_min"))
      ext_away_min = val;
    if(!strcmp(var,"ext_away_sec"))
      ext_away_sec = val;
    if(!strcmp(var,"desc_num"))
      desc_num = val;
    if(!strcmp(var,"width"))
    {
      width=val;
    }
    if(!strcmp(var,"height"))
    {
      height=val;
    }
    if(!strcmp(var,"endsection1"))
    {
      break;
    }
  }
  if(groups_unknown)
    preferences |= PREF_GROUPS_NONE;
  //sekcja druga %s %s
  while(!feof(f))
  {
    fscanf(f,"%s %s\n",var,vals);
    if(!strcmp(var,"datefg"))
      datefg=g_strdup(vals);
    if(!strcmp(var,"nickfg"))
      nickfg=g_strdup(vals);
    if(!strcmp(var,"textfg"))
      textfg=g_strdup(vals);
    if(!strcmp(var,"textbg"))
      textbg=g_strdup(vals);
//    if(!strcmp(var,"jabberjid"))
//    {
//      jabberjid=g_strdup(vals);
//    }
//    if(!strcmp(var,"jabberpassword"))
//    {
//      jabberpassword=g_strdup(vals);
//    }
    if(!strcmp(var,"soundm"))
    {
      sounds[SOUNDM]=g_strdup(vals);
    }
    if(!strcmp(var,"sounds"))
    {
      sounds[SOUNDS]=g_strdup(vals);
    }
    if(!strcmp(var,"sounda"))
    {
      sounds[SOUNDA]=g_strdup(vals);
    }
    if(!strcmp(var,"soundn"))
    {
      sounds[SOUNDN]=g_strdup(vals);
    }
    if(!strcmp(var,"soundw"))
    {
      sounds[SOUNDW]=g_strdup(vals);
    }
    if(!strcmp(var,"soundt"))
    {
      sounds[SOUNDT]=g_strdup(vals);
    }
    if(!strcmp(var,"playpath"))
      playpath=g_strdup(vals);
    if(!strcmp(var,"browser"))
      browser=g_strdup(vals);
    if(!strcmp(var,"begindesc"))
    {
      gchar *l;

      while(!feof(f))
      {
        l = read_line(f);
        if(!l)
          break;
        desc_list_append(l);
        g_free(l);
      }
      break;
    }
  }
  if(profile->jserver)
    preferences |= PREF_JABBER_CONNECT;

  fclose(f);
  return 0;
}

/* Load cached list of groups which should be expanded
 * return: 1 - can't open file, 0 success */
gint file_load_expanded_groups()
{
	gchar *s = NULL;
	FILE *file = NULL;

	s = g_strdup_printf("%s/.tleenx/%s.cached_groups", 
			getenv("HOME"), pname);
	if( !(file = fopen(s, "r")) ) {
		tleenx_print(WARNING, "Can't open file %s.", s);
		g_free(s);
		return 1;
	}
	
	g_free(s);
	s = NULL;
	
	while(!feof(file)) {
		s = read_line(file);
		if(preferences & PREF_DEBUGON)
			tleenx_print(DEBUG, "file_load_expanded_groups(): got %s\n", s);
		if(!s)
			break;
		list_expanded_group_set(s);
		g_free(s);
		s = NULL;
	}
	fclose(file);

	return 0;
}


/* Write list of groups which should be expanded
 * return: 1 - can't create file, 0 success */
gint file_write_expanded_groups()
{
	gchar *s = NULL;
	FILE *file = NULL;
	GList *groups = NULL;
	struct group *g = NULL;
	
	s = g_strdup_printf("%s/.tleenx/%s.cached_groups", 
			getenv("HOME"), pname);
	if( !(file = fopen(s, "w")) ) {
		tleenx_print(WARNING, "Can't open file %s for writing", s);
		g_free(s);
		return 1;
	}
	
	g_free(s);

	groups = groups_list;
	while(groups) {
		g = (struct group *)groups->data;
		if(list_is_group_expanded(g->name))
			g_fprintf(file, "%s\n", g->name);
		groups = groups->next;
		g = NULL;
	}
	fclose(file);

	return 0;
}
