/*
** Jabby (a C library for Jabber protocol)
** Copyright (c) 2002 Hubert Sokoowski <who_ami@tlen.pl>
**
** This code is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public License.
**
*/

#ifndef _JABBY_H_
#define _JABBY_H_

#ifdef __cplusplus
extern "C" {
#endif

#include <glib.h>
#include "../iksemel/iksemel.h"
	


enum netstates
{
  JABBY_NET_OFF,
  JABBY_NET_CONNECT,
  JABBY_NET_STREAM,
  JABBY_NET_REG,
  JABBY_NET_AUTH,
  JABBY_NET_ON
};

typedef struct
{
  iksid *id;
  gchar *pass;
  iksparser *parser;
  enum netstates state;
  gboolean debug;
} jabby_session;

typedef struct
{
  gchar *jid;
  gchar *name;
  gchar *subscription;
  gchar *group;
  gchar *ask;
} jabby_roster;

enum jabby_event_type{
  JABBY_EVENT_UNKNOWN = 0,
  JABBY_EVENT_NONE,
  JABBY_EVENT_ERROR,
  JABBY_EVENT_MESSAGE,
  JABBY_EVENT_PRESENCE,
  JABBY_EVENT_SUBSCRIBE,
  JABBY_EVENT_SUBSCRIBED,
  JABBY_EVENT_UNSUBSCRIBE,
  JABBY_EVENT_UNSUBSCRIBED,
  JABBY_EVENT_ROSTER_ITEM,
  JABBY_EVENT_ROSTER_END,
  JABBY_EVENT_UNAUTHORIZED,
  JABBY_EVENT_UNAUTHORIZED_TRANSPORT,
  JABBY_EVENT_CONNECTION_FAILED,
  JABBY_EVENT_DISCONNECT,
  JABBY_EVENT_SEARCH_ITEM,
  JABBY_EVENT_SEARCH_END,
  JABBY_EVENT_AGENT,
  JABBY_EVENT_AGENTS_END,
  JABBY_EVENT_REGISTERED
};

enum jabby_presence_type{
  JABBY_PRESENCE_UNAVAILABLE = 0,
  JABBY_PRESENCE_AVAILABLE,
  JABBY_PRESENCE_CHAT,
  JABBY_PRESENCE_AWAY,
  JABBY_PRESENCE_XA,
  JABBY_PRESENCE_DND,
  JABBY_PRESENCE_INVISIBLE
};

enum jabby_message_type{
  JABBY_MESSAGE_NORMAL,
  JABBY_MESSAGE_CHAT,
  JABBY_MESSAGE_ERROR
};

typedef struct
{
  gchar *to;
} jabby_event_registered;

typedef struct
{
  gchar *jid;
  gchar *name;
  gchar *service;
  gchar *transport;
} jabby_event_agent;

typedef struct
{
  gchar *message;
} jabby_event_error;

typedef struct
{
  gchar *from;
  gchar *id;
  enum jabby_message_type type;
  gchar *body;
  gchar *subject;
  gchar *thread;
  gchar *error;
  gchar *delay;
} jabby_event_message;

typedef struct
{
  gchar *from;
  gchar *status;
} jabby_event_subscribe;

typedef struct
{
  gchar *from;
  gchar *status;
} jabby_event_unsubscribe;

typedef struct
{
  gchar *from;
} jabby_event_subscribed;

typedef struct
{
  gchar *from;
  gchar *status;
} jabby_event_unsubscribed;

typedef struct
{
  gchar *from;
  enum jabby_presence_type type;
  gchar *message;
} jabby_event_presence;

typedef struct
{
  gchar *id;
  gchar *first;
  gchar *last;
  gchar *nick;
  gint age;
  gchar *city;
  gint population;
  gint province;
  gint sex;
  gint occupation;
  gint online;
} jabby_search_res;

typedef struct
{
  enum jabby_event_type type;
  union{
    jabby_event_error *error;
    jabby_event_message *message;
    jabby_event_subscribe *subscribe;
    jabby_event_unsubscribe *unsubscribe;
    jabby_event_subscribed *subscribed;
    jabby_event_unsubscribed *unsubscribed;
    jabby_roster *roster;
    jabby_event_presence *presence;
    jabby_search_res *search;
    jabby_event_agent *agent;
    jabby_event_registered *registered;
  } event;
} jabby_event;


#define JABBY_SEARCH_SEX_NONE 0
#define JABBY_SEARCH_SEX_MALE 1
#define JABBY_SEARCH_SEX_FEMALE 2
#define JABBY_SEARCH_OCCUPATION_NONE 0
#define JABBY_SEARCH_OCCUPATION_J1 1
#define JABBY_SEARCH_OCCUPATION_J2 2
#define JABBY_SEARCH_OCCUPATION_J3 3
#define JABBY_SEARCH_OCCUPATION_J4 4
#define JABBY_SEARCH_OCCUPATION_J5 5
#define JABBY_SEARCH_OCCUPATION_J6 6
#define JABBY_SEARCH_OCCUPATION_J7 7
#define JABBY_SEARCH_OCCUPATION_J8 8
#define JABBY_SEARCH_OCCUPATION_J9 9
#define JABBY_SEARCH_OCCUPATION_J10 10
#define JABBY_SEARCH_OCCUPATION_J11 11
#define JABBY_SEARCH_STATUS_NONE 0
#define JABBY_SEARCH_STATUS_YES 1
#define JABBY_SEARCH_POPULATION_NONE 0
#define JABBY_SEARCH_POPULATION_S1 1
#define JABBY_SEARCH_POPULATION_S2 2
#define JABBY_SEARCH_POPULATION_S3 3
#define JABBY_SEARCH_POPULATION_S4 4
#define JABBY_SEARCH_POPULATION_S5 5
#define JABBY_SEARCH_PROVINCE_NONE 0
#define JABBY_SEARCH_PROVINCE_R1 1
#define JABBY_SEARCH_PROVINCE_R2 2
#define JABBY_SEARCH_PROVINCE_R3 3
#define JABBY_SEARCH_PROVINCE_R4 4
#define JABBY_SEARCH_PROVINCE_R5 5
#define JABBY_SEARCH_PROVINCE_R6 6
#define JABBY_SEARCH_PROVINCE_R7 7
#define JABBY_SEARCH_PROVINCE_R8 8
#define JABBY_SEARCH_PROVINCE_R9 9
#define JABBY_SEARCH_PROVINCE_R10 10
#define JABBY_SEARCH_PROVINCE_R11 11
#define JABBY_SEARCH_PROVINCE_R12 12
#define JABBY_SEARCH_PROVINCE_R13 13
#define JABBY_SEARCH_PROVINCE_R14 14
#define JABBY_SEARCH_PROVINCE_R15 15
#define JABBY_SEARCH_PROVINCE_R16 16

typedef struct
{
  gchar *id;
  gchar *nick;  // add by Lolek to can search in gg by uin and nick
  gchar *first;
  gchar *last;
  gint age_min;
  gint age_max;
  gchar *city;
  gint population;
  gint province;
  gint sex;
  gint occupation;
  gint online;
} jabby_search_set;

/*
   *
   * prototypes
   *
*/

jabby_session *jabby_session_new(gchar *id, gchar *pass);
gint jabby_connect(jabby_session *ses);
jabby_event *jabby_event_next(jabby_session *ses);
void jabby_disconnect(jabby_session *ses);
void jabby_get_roster(jabby_session *ses);
void jabby_event_free(jabby_event *event);
gint jabby_presence(jabby_session *ses, enum jabby_presence_type type,
                    gchar *message, gchar *to);
gint jabby_contact_add(jabby_session *ses, gchar *name, gchar *jid,
                       gchar *group);
gint jabby_contact_remove(jabby_session *ses, gchar *jid);
gint jabby_subscribe_ask(jabby_session *ses, gchar *jid, gchar *status);
gint jabby_subscribe_accept(jabby_session *ses, gchar *jid);
gint jabby_subscribe_deny(jabby_session *ses, gchar *jid);
gint jabby_unsubscribe(jabby_session *ses, gchar *jid);
gint jabby_message(jabby_session *ses, gchar *to, gchar *id, gchar *message,
                   gchar *subject, enum jabby_message_type type);
void jabby_session_free(jabby_session *ses);
void jabby_get_agents(jabby_session *ses);
void jabby_register_to(jabby_session *ses, gchar *to, gchar *username,
                       gchar *password);

/* pubdir search*/
jabby_search_set *jabby_search_set_new();
void jabby_search_set_free(jabby_search_set *search);
void jabby_search_wp(jabby_session *ses, jabby_search_set *search);
void jabby_gg_search_start(jabby_session *session, jabby_search_set *search);

/*
   *
   * others
   *
*/


#ifdef __cplusplus
}
#endif

#endif
