# $Id: icon.tcl 955 2007-02-20 21:19:14Z sergei $
# Titlebar icons support. Works with Tk 8.5 or newer.

##########################################################################

namespace eval icon {
    hook::add finload_hook [namespace current]::win_icons
}

##########################################################################

proc icon::win_icons {} {
    if {[catch {wm iconphoto . roster/user/unavailable}]} return

    trace variable ::curuserstatus w [namespace code update_icon]

    foreach tag [list Toplevel Chat JBrowser JDisco] {
	bind $tag <Map> \
	     [list [namespace code win_icon_setup] %W]
    }
}

##########################################################################

proc icon::win_icon_setup {w} {
    if {$w == "."} return
    if {[winfo toplevel $w] != $w} return
    if {[catch {list [$w configure -class] 4} tag]} return

    switch -- $tag {
	Chat {
	    wm iconphoto $w roster/conference/available
	}
	JBrowser -
	JDisco {
	    wm iconphoto $w roster/user/available
	}
	Toplevel {
	    wm iconphoto $w roster/user/available
	}
    }
}

##########################################################################

proc icon::update_icon {name1 {name2 ""} {op ""}} {
    global curuserstatus

    wm iconphoto . roster/user/$curuserstatus
}

##########################################################################

proc icon::update_all_icons {} {
    catch {
	foreach w [concat . [winfo children .]] {
	    win_icon_setup $w
	}
	update_icon curuserstatus
    }
}

hook::add set_theme_hook [namespace current]::icon::update_all_icons

##########################################################################

