# $Id: copy_jid.tcl 870 2007-01-14 11:08:37Z sergei $
# Copy JID to clipboard

###############################################################################

namespace eval copy_jid {}

###############################################################################

proc copy_jid::copy {m jid} {
    clipboard clear -displayof $m
    clipboard append -displayof $m $jid
}

###############################################################################

proc copy_jid::add_menu_item {m connid jid} {
    $m add command \
	   -label [::msgcat::mc "Copy JID to clipboard"] \
	   -command [list [namespace current]::copy $m $jid]
}

hook::add roster_create_groupchat_user_menu_hook \
    [namespace current]::copy_jid::add_menu_item 44
hook::add chat_create_user_menu_hook \
    [namespace current]::copy_jid::add_menu_item 44
hook::add chat_create_conference_menu_hook \
    [namespace current]::copy_jid::add_menu_item 44
hook::add roster_jid_popup_menu_hook \
    [namespace current]::copy_jid::add_menu_item 44
hook::add roster_conference_popup_menu_hook \
    [namespace current]::copy_jid::add_menu_item 44
hook::add roster_service_popup_menu_hook \
    [namespace current]::copy_jid::add_menu_item 44
hook::add message_dialog_menu_hook \
    [namespace current]::copy_jid::add_menu_item 44
hook::add search_popup_menu_hook \
    [namespace current]::copy_jid::add_menu_item 44

###############################################################################

