# $Id: plugins.tcl 828 2006-12-15 20:58:11Z sergei $

namespace eval plugins {}

proc plugins::load {dir args} {
    set dir [fullpath $dir]
    set uplev 0
    foreach {attr val} $args {
	switch -- $attr {
	    -uplevel {set uplev $val}
	}
    }

    foreach file [glob -nocomplain $dir/*.tcl] {
	debugmsg plugins "Loading plugin from $file"
	if {$uplev} {
	    uplevel [list source $file]
	} else {
	    source $file
	}
    }
}

proc plugins::load_dir {plugins_dir} {
    foreach dir [lsort [glob -nocomplain -type {d l} [file join $plugins_dir *]]] {
	set file [file join $dir [file tail $dir].tcl]
	if {[file exists $file]} {
	    debugmsg plugins "Loading plugin from $file"
	    source $file
	} else {
	    debugmsg plugins "Can't load plugin from $file"
	}
    }
}

