#ifndef INDII_TINT_GUI_THUMBIMAGE_HPP
#define INDII_TINT_GUI_THUMBIMAGE_HPP

#include "../ImageResource.hpp"
#include "../ClusterModel.hpp"
#include "../ClusterModelObserver.hpp"

#include "wx/panel.h"
#include "wx/control.h"
#include "wx/bitmap.h"
#include "wx/dcclient.h"

namespace indii {
  namespace tint {
    namespace gui {
/**
 * Image preview.
 *
 * @author Lawrence Murray <lawrence@indii.org>
 * @version $Rev: 92 $
 * @date $Date: 2009-08-02 17:56:45 +0800 (Sun, 02 Aug 2009) $
 */
class ThumbImage : public wxControl, public ClusterModelObserver {
public:
  /**
   * Constructor.
   *
   * @param parent Parent window.
   * @param res Image resource manager. Caller retains ownership.
   * @param model Cluster model. Caller retains ownership.
   * @param cluster Cluster number to which this thumbnail pertains.
   */
  ThumbImage(wxWindow *parent, ImageResource* res, ClusterModel* model,
      const unsigned int cluster);

  /**
   * Destructor.
   */
  ~ThumbImage();

  virtual void notifyNumClustersChange();

  virtual void notifySaturationDecayChange();

  virtual void notifyCentroidDecayChange();

  virtual void notifySaturationSoftnessChange();

  virtual void notifyCentroidSoftnessChange();

  virtual void notifyClusterChange(const unsigned int i);  

  /**
   * Handle paint event.
   */
  void OnPaint(wxPaintEvent& evt);

  /**
   * Handle left mouse button down event.
   */
  void OnLeftDown(wxMouseEvent& evt);

  /**
   * Handle left mouse button up event.
   */
  void OnLeftUp(wxMouseEvent& evt);

  /**
   * Handle mouse leave event.
   */
  void OnLeave(wxMouseEvent& evt);

private:
  /**
   * Image resource manager.
   */
  ImageResource* res;

  /**
   * Cluster model.
   */
  ClusterModel* model;

  /**
   * Cluster number.
   */
  unsigned int cluster;

  /**
   * Is thumbnail active? (in active state, even if cluster not selected,
   * e.g. on mouse button down event).
   */
  bool isActive;

  /**
   * Scale of the thumbnail compared to original image.
   */
  unsigned int scale;
  
  /**
   * Colour layer of thumbnail.
   */
  wxBitmap fg;

  /**
   * B&W layer of thumbnail.
   */
  wxBitmap bg;

  /**
   * Alpha channel of thumbnail.
   */
  channel a;

  /**
   * Is foreground prepared?
   */
  bool fgPrepared;

  /**
   * Prepare background.
   */
  void prepareBackground();

  /**
   * Prepare foreground.
   */
  void prepareForeground();

  DECLARE_EVENT_TABLE()

};

    }
  }
}

#endif
