import gobject
import pynotify

class Notifier(object):
    _NOTIFICATION_REDISPLAY_INTERVAL_SECONDS = 60

    def __init__(self, app_name, icon, attach):
        self._icon = icon
        self._attach = attach
        self._notify = None
        self._handler_id = None
        self._timeout_id = None
        
        if not pynotify.is_initted():
            pynotify.init(app_name)

    def begin(self, summary, body, get_reminder_message_func):
        self.end()
        self._notify = pynotify.Notification(summary, body, self._icon, self._attach)
        self._handler_id = self._notify.connect('closed', self._on_notification_closed, get_reminder_message_func)
        self._notify.show()
        
    def end(self):
        if self._notify is not None:
            if self._timeout_id is not None:
                gobject.source_remove(self._timeout_id)
                self._timeout_id = None
            self._notify.disconnect(self._handler_id)
            self._handler_id = None
            self._notify.close()
            self._notify = None
            
    def _on_notification_closed(self, notification, get_reminder_message_func):
        self._timeout_id = gobject.timeout_add(Notifier._NOTIFICATION_REDISPLAY_INTERVAL_SECONDS * 1000,
                                               self._on_notification_redisplay_timeout,
                                               get_reminder_message_func)
        
    def _on_notification_redisplay_timeout(self, get_reminder_message_func):
        message = get_reminder_message_func()
        self._notify.props.body = message
        self._notify.show()
        
        self._timeout_id = None
        return False
