/*
 *	libetm-0.4 / libetm.h - Copyright (C) Emmanuel Thomas-Maurin 2008-2012
 * 	<manutm007@gmail.com>
 *
 * 	This program is free software: you can redistribute it and/or modify
 * 	it under the terms of the GNU General Public License as published by
 * 	the Free Software Foundation, either version 3 of the License, or
 * 	(at your option) any later version.
 *
 * 	This program is distributed in the hope that it will be useful,
 * 	but WITHOUT ANY WARRANTY; without even the implied warranty of
 * 	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * 	GNU General Public License for more details.
 *
 * 	You should have received a copy of the GNU General Public License
 * 	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef INC_LIBETM_H
#define INC_LIBETM_H

#define LIBETM_NAME		"Libetm"
#define LIBETM_VERSION_NUM	"0.4.4"

#ifndef _GNU_SOURCE
#define _GNU_SOURCE
#endif
#ifndef _ISOC99_SOURCE
#define _ISOC99_SOURCE
#endif

/*#define LIBETM_EXPERIMENTAL_STUFF*/

#ifndef FALSE
# ifndef TRUE
#  define FALSE		(0)
#  define TRUE		(!FALSE)
# endif
#endif

/* Would it be better like that?
#undef FALSE
#undef TRUE
typedef enum {
	FALSE = (0), TRUE = (!FALSE)
} boolean;*/

#define YES		(1)
#define NO		(0)

#ifndef MAX
# define MAX(x,y)	((x) > (y) ? (x) : (y))
#endif

#ifndef MIN
# define MIN(x,y)	((x) < (y) ? (x) : (y))
#endif

#ifndef ABS
# define ABS(x)		((x) > 0 ? (x) : -(x))
#endif

/* Do more testing for the 2 following ones */
#ifndef SIGN
# define SIGN(x)	((x) != 0 ? ((x) > 0 ? 1 : -1) : 0)
#endif

/* Only if f > 0 */
#ifndef APPROX
# define APPROX(f)	(ABS(((f) - (int)(f)) > 0.5) ? (int)(f) + SIGN((f)) : (int)(f))
#endif

#include "str_mem.h"
#include "misc.h"
#include "error.h"
#include "win32_specific.h"
#endif /* INC_LIBETM_H */
