/*
 * This func's prototype is in libetm / error.h.
 * This func is not defined in libetm but in app and it handles errors
 * from libetm and app.
 *
 * Max number of strings = N_STR_MAX, max string length = STR_MAXLEN.
 * Outstanding stuff (strings and chars) will be ignored.
 */
int big_error(int big_error_code, int n_str, ...)
{
#define N_STR_MAX	8
#define STR_MAXLEN	128

	char		error_str[32 + 32 + (N_STR_MAX * STR_MAXLEN) + 32 + 1];
	va_list	str;
	int		i;

	error_str[0] = '\0';
	str_n_cpy(error_str, "CRITICAL ERROR: ", 32);
	if (big_error_code > LIBETM_LASTERRORCODE)
		str_n_cat(error_str, APP_NAME": ", 32);
	n_str = MIN(n_str, N_STR_MAX);
	va_start(str, n_str);
	for (i = 0; i < n_str ; i++)
		str_n_cat(error_str, va_arg(str, char *), STR_MAXLEN);
	va_end(str);
	str_n_cat(error_str, " - Will quit now", 32);

	fprintf(STD_ERR, "%s\n", error_str);
	fflush(NULL);
	exit(big_error_code);
}
