/***************************************************************************
                             th-parsetter.h
                             --------------
    begin                : Sat Mar 26 2007
    copyright            : (C) 2007 by Tim-Philipp Müller
    email                : t.i.m@orange.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This element forces a given pixel-aspect-ratio on a video stream,     *
 *   which is required to work around a bug in libmpeg2/mpeg2dec, see      *
 *   http://bugzilla.gnome.org/show_bug.cgi?id=323332 for details.         *
 *                                                                         *
 ***************************************************************************/


#ifndef _th_par_setter_h_included_
#define _th_par_setter_h_included_

#include <gst/gst.h>
#include <gst/base/gstbasetransform.h>

#define TH_TYPE_PAR_SETTER            (th_par_setter_get_type())
#define TH_PAR_SETTER(obj)            (G_TYPE_CHECK_INSTANCE_CAST((obj),TH_TYPE_PAR_SETTER,ThParSetter))
#define TH_PAR_SETTER_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass),TH_TYPE_PAR_SETTER,ThParSetterClass))
#define TH_IS_PAR_SETTER(obj)         (G_TYPE_CHECK_INSTANCE_TYPE((obj),TH_TYPE_PAR_SETTER))
#define TH_IS_PAR_SETTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass),TH_TYPE_PAR_SETTER))

typedef struct _ThParSetter       ThParSetter;
typedef struct _ThParSetterClass  ThParSetterClass;

struct _ThParSetter 
{
  GstBaseTransform  basetrans;

  GValue            par;  /* pixel-aspect-ratio to force on the output */
};

struct _ThParSetterClass 
{
  GstBaseTransformClass  basetransclass;
};

GType   th_par_setter_get_type (void);

#endif /* _th_par_setter_h_included_ */


