/***************************************************************************
                             th-plugins.c
                             ------------
    begin                : Sun Apr 30 2006
    copyright            : (C) 2006 by Tim-Philipp Müller
    email                : t.i.m@orange.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include "th-plugins.h"
#include "th-parsetter.h"
#include "th-pixbufsink.h"
#include "th-deinterlace.h"

/***************************************************************************
 *
 *   th_ensure_static_plugins
 *
 *   Make sure our static plugins are not optimised away by the linker
 *
 ***************************************************************************/

gboolean
th_ensure_static_plugins (void)
{
	if (!th_pixbuf_sink_get_type ())
		return FALSE;
	
	return TRUE;
}


/***************************************************************************
 *
 *   plugin_init
 *
 ***************************************************************************/

static gboolean
plugin_init (GstPlugin *plugin)
{
	g_print ("registering static thoggen plugins\n");

	if (!gst_element_register (plugin, "thpixbufsink", GST_RANK_NONE,
	    TH_TYPE_PIXBUF_SINK)) {
		return FALSE;
	}

	if (!gst_element_register (plugin, "thdeinterlace", GST_RANK_NONE,
	    TH_TYPE_DEINTERLACE)) {
		return FALSE;
	}

	if (!gst_element_register (plugin, "thparsetter", GST_RANK_NONE,
	    TH_TYPE_PAR_SETTER)) {
		return FALSE;
	}

	return TRUE;
}

GST_PLUGIN_DEFINE_STATIC
(
	GST_VERSION_MAJOR,
	GST_VERSION_MINOR,
	"thoggen-elements",
	"Thoggen static elements", 
	plugin_init, 
	VERSION, 
	"LGPL", 
	"Thoggen", 
	"http://thoggen.net"
)
