#!/usr/bin/perl -w

# Copyright 2006 Martin Budaj
# assumptions: start 1900, interval 5 years, only last model extrapolated

$degmax = 0;
$yearmin = 10000;
$yearmax = 0;

sub y2y {
  my $y = shift;
  return int(($y-1900) / 5 + 0.5);  # 1900 hardcoded
}

open (IN, "IGRF10.cof");
while (<IN>) {
  chomp;
  if (/^ {3,5}(\S+)\s+(\d{4}\.\d{2})\s+(\d+)\s+(\d+)\s+(\d+)\s+(\d{4}\.\d{2})\s+(\d{4}\.\d{2})/) {
    #$model = $1;
    $year = $2;
    $deg = $3;
    $deg2 = $4;
    if ($yearmin > $6) {$yearmin = $6;}
    if ($yearmax < $7) {$yearmax = $7;}
#    print $model . "\n";
    if ($deg2 > 0.1) {$DATA{y2y($year)}{"extr"} = 1;}
    else             {$DATA{y2y($year)}{"extr"} = 0;}
    if ($deg > $degmax) {$degmax = $deg;}
  }
  elsif (/^[ \d]\d[ \d]\d/) {
    $i = substr($_, 0, 2) + 0.0;
    $j = substr($_, 2, 2) + 0.0;
    $a = substr($_, 4, 8) + 0.0;
    $b = substr($_,12, 8) + 0.0;
    $c = substr($_,20, 8) + 0.0;
    $d = substr($_,28, 8) + 0.0;
    $DATAa{y2y($year)}{$i}{$j} = $a;
    $DATAb{y2y($year)}{$i}{$j} = $b;
    $DATAc{y2y($year)}{$i}{$j} = $c;
    $DATAd{y2y($year)}{$i}{$j} = $d;
  }
}

close IN;

#print "$yearmin $yearmax $year\n";

open (OUT, ">../thgeomagdata.h");
print OUT "// generated by geomag/cof2c.pl\n\n#ifndef thgeomagdata_h\n#define thgeomagdata_h\n\n";
print OUT "static const double thgeomag_GNM[" , y2y($year) + 1,
	   "][", $degmax+1, "][", $degmax+1, "] = {\n";
foreach $y (sort {$a <=> $b} keys %DATA) {
  print OUT "{\n";
  for $j (0 .. $degmax) {
    print OUT "  {";
    for $i (0 .. $degmax) {
      print OUT $DATAa{$y}{$i}{$j} ? $DATAa{$y}{$i}{$j} : 0, ", ";
    }
    print OUT "},\n";
  }
  print OUT "},\n";
}
print OUT "};\n";

print OUT "static const double thgeomag_HNM[" , y2y($year) + 1,
	   "][", $degmax+1, "][", $degmax+1, "] = {\n";
foreach $y (sort {$a <=> $b} keys %DATA) {
  print OUT "{\n";
  for $j (0 .. $degmax) {
    print OUT "  {";
    for $i (0 .. $degmax) {
      print OUT $DATAb{$y}{$i}{$j} ? $DATAb{$y}{$i}{$j} : 0, ", ";
    }
    print OUT "},\n";
  }
  print OUT "},\n";
}
print OUT "};\n";

foreach $y (keys %DATA) {
  die "extrapolated data missing\n" if (($DATA{$y}{"extr"} == 0) && ($y == y2y($year)));
  die "extrapolated data too early\n" if (($DATA{$y}{"extr"} == 1) && ($y != y2y($year)));
}

print OUT "static const double thgeomag_GNMD[", $degmax+1, "][", $degmax+1, "] = {\n";
for $j (0 .. $degmax) {
  print OUT "  {";
  for $i (0 .. $degmax) {
    print OUT $DATAc{y2y($year)}{$i}{$j} ? $DATAc{y2y($year)}{$i}{$j} : 0, ", ";
  }
  print OUT "},\n";
}
print OUT "};\n";

print OUT "static const double thgeomag_HNMD[", $degmax+1, "][", $degmax+1, "] = {\n";
for $j (0 .. $degmax) {
  print OUT "  {";
  for $i (0 .. $degmax) {
    print OUT $DATAd{y2y($year)}{$i}{$j} ? $DATAd{y2y($year)}{$i}{$j} : 0, ", ";
  }
  print OUT "},\n";
}
print OUT "};\n";

print OUT "#define thgeomag_maxmindex ", y2y($year), "\n";
print OUT "#define thgeomag_step 5\n";
print OUT "#define thgeomag_minyear ", $yearmin+0.0, "\n";
print OUT "#define thgeomag_maxdeg ", $degmax+0.0, "\n";
print OUT "\n#endif\n\n";

close OUT;

