/* Copyright (C) 1988-1998 Takafumi Sakurai
 * Permission to use, copy, modify, and distribute this file for any
 * purpose is hereby granted without fee, provided that both the above
 * copyright notice and this permission appear in all copies.
*/

#define	NOFIXPUTC
#define	EXTERN extern
#include "texd.h"

#define	MAXOPEN		64
mlcinfo mlcodeinfo[MAXOPEN];

#define	MAX_ONE94_IDX	('M'-'@')
int iso_fin_one94[] = {
    MC_ASCII,	/* */
    MC_ASCII,	/* */
    MC_ASCII,	/* B */
    MC_ASCII,	/* */
    MC_ASCII,	/* */
    MC_ASCII,	/* */
    MC_ASCII,	/* */
    MC_ASCII,	/* */
    MC_ASCII,	/* */
    MC_KANA,	/* I */
    MC_ROMAN,	/* J */
    MC_ASCII,	/* */
    MC_ASCII,	/* */
    MC_ASCII,	/* */
};

#define	MAX_ONE96_IDX	('T'-'@')
int iso_fin_one96[] = {
    MC_ASCII,	/* */
    MC_LTN1,	/* A */
    MC_LTN2,	/* B */
    MC_LTN3,	/* C */
    MC_LTN4,	/* D */
    MC_ASCII,	/* */
    MC_GRK,	/* F */
    MC_ARB,	/* G */
    MC_HBW,	/* H */
    MC_ASCII,	/* */
    MC_ASCII,	/* */
    MC_ASCII,	/* */
    MC_CRL,	/* L */
    MC_LTN5,	/* M */
    MC_ASCII,	/* */
    MC_ASCII,	/* */
    MC_ASCII,	/* */
    MC_ASCII,	/* */
    MC_ASCII,	/* */
    MC_ASCII,	/* */
    MC_THAI,	/* T */
};

#define	MAX_TWO_IDX	('D'-'@')
int iso_fin_two94[] = {
    MC_JPOLD,	/* @ */
    MC_CN,	/* A */
    MC_JP,	/* B */
    MC_KR,	/* C */
    MC_JPS,	/* D */
};

#define	MAX_ESC_IDX	MC_BIG52
char iso_esc_tab[][4] = {
    "(B",	/* ascii */
    ",A",	/* ltn1 */
    ",B",	/* ltn2 */
    ",C",	/* ltn3 */
    ",D",	/* ltn4 */
    ",T",	/* thai */
    ",F",	/* grk */
    ",G",	/* arb */
    ",H",	/* hbw */
    "(I",	/* kana */
    "(J",	/* roman */
    "",
    ",L",	/* crl */
    ",M",	/* ltn5 */
    "",
    "",
    "$@",	/* jpold */
    "$A",	/* cn */
    "$B",	/* jp */
    "$(C",	/* kr */
    "$(D",	/* jp2 */
    "",		/* cns1 */
    "",		/* cns2 */
    "",
    "$(0",	/* big5-1 */
    "$(1",	/* big5-2 */
};

/*
 * Input
 */
int in_ln_ascii(f, mi)
FILE *f;
mlcinfo *mi;
{
    int i;

    while (last < bufsize && ((i = getc(f)) != EOF) && i != '\n' && i != '\r')
	buffer[last++] = i;
    return i;
}

left_1ch(c, mi)
textchar c;
mlcinfo *mi;
{
    buffer[last++] = make_mlrep1(mi->GLset,c);
}

right_1ch(c, mi)
textchar c;
mlcinfo *mi;
{
    if (Rctrl(c))
	buffer[last++] = c;
    else if (mi->GRset == MC_ASCII)
	buffer[last++] = make_mlrep1(MC_ASCII,c);
    else
	buffer[last++] = make_mlrep1(mi->GRset,c&0x7f);
}

left_pend(c, mi)
textchar c;
mlcinfo *mi;
{
    mi->inpend = c;
    mi->instat = ISO_GL22;
}

left_make(c, mi)
textchar c;
mlcinfo *mi;
{
    buffer[last++] = make_mlrep(mi->GLset,mi->inpend,c);
    mi->instat = ISO_ONE;
}

left_make_jp(c, mi)
textchar c;
mlcinfo *mi;
{
    fix_kanji_range(&(mi->inpend), &c);
    buffer[last++] = make_mlrep(mi->GLset,mi->inpend,c);
    mi->instat = ISO_ONE;
}

right_pend(c, mi)
textchar c;
mlcinfo *mi;
{
    if (Rctrl(c))
	buffer[last++] = c;
    else {
	mi->inpend = c;
	mi->instat = ISO_GR22;
    }
}

right_make(c, mi)
textchar c;
mlcinfo *mi;
{
    if (c&0x80) {
	buffer[last++] = make_mlrep(mi->GRset,mi->inpend&0x7f,c&0x7f);
    } else {
	buffer[last++] = make_mlrep1(MC_ASCII,mi->inpend);
	buffer[last++] = c;
    }
    mi->instat = ISO_ONE;
}

right_make_jp(c, mi)
textchar c;
mlcinfo *mi;
{
    textchar c1, c2;

    if (c&0x80) {
	c1 = mi->inpend&0x7f;
	c2 = c&0x7f;
	fix_kanji_range(&c1, &c2);
	buffer[last++] = make_mlrep(mi->GRset,c1,c2);
    } else {
	buffer[last++] = make_mlrep1(MC_ASCII,mi->inpend);
	buffer[last++] = c;
    }
    mi->instat = ISO_ONE;
}

ignore_1ch(c, mi)
textchar c;
mlcinfo *mi;
{
}

eight_1ch(c, mi)
textchar c;
mlcinfo *mi;
{
    buffer[last++] = make_mlrep1(MC_ASCII,c);
}

sjis_pend(c, mi)
textchar c;
mlcinfo *mi;
{
    if (c >= 0xe0 || c >= 0x80 && c < 0xa0) {
	mi->inpend = c;
	mi->instat = ISO_GR22;
    } else {	/* 1-byte kana */
	buffer[last++] = make_mlrep1(MC_KANA,c&0x7f);
    }
}

sjis_make(c, mi)
textchar c;
mlcinfo *mi;
{
    textchar c1, c2;

    sj2iso(mi->inpend, c, c1, c2);
    fix_kanji_range(&c1, &c2);
    buffer[last++] = make_mlrep(MC_JP,c1,c2);
    mi->instat = ISO_ONE;
}

fix_kanji_range(c1, c2)
textchar *c1, *c2;
{
    if (*c1 < 0x21 || (*c1 >= 0x29 && *c1 <= 0x2f) || *c1 >= 0x75) {
	*c1 = 0x22;
	*c2 = 0x23;
    }
}

big5h_make(c, mi)
textchar c;
mlcinfo *mi;
{
    textchar c1, c2;
    int mc;

    bvh2iso(mi->inpend, c, mc, c1, c2);
    buffer[last++] = make_mlrep(mc,c1,c2);
    mi->instat = ISO_ONE;
}

big5e_make(c, mi)
textchar c;
mlcinfo *mi;
{
    textchar c1, c2;
    int mc;

    bve2iso(mi->inpend, c, mc, c1, c2);
    buffer[last++] = make_mlrep(mc,c1,c2);
    mi->instat = ISO_ONE;
}

#define	one94_des(cr, fin, mi)	\
	if ('@' <= fin && fin <= 'M') \
	    mi->Gchsets[cr] = iso_fin_one94[fin-'@']; \
	else if (fin == '0')	/* Mule private */ \
	    mi->Gchsets[cr] = MC_SISHENG; \
	else if (fin == '1')	/* Mule private */ \
	    mi->Gchsets[cr] = MC_THAI; \
	else if (fin == '2')	/* Mule private */ \
	    mi->Gchsets[cr] = MC_ARBD; \
	else if (fin == '3')	/* Mule private */ \
	    mi->Gchsets[cr] = MC_ARB1; \
	else \
	    mi->Gchsets[cr] = MC_ASCII;

#define	one96_des(cr, fin, mi)	\
	if ('@' <= fin && fin <= 'T') \
	    mi->Gchsets[cr] = iso_fin_one96[fin-'@']; \
	else if (fin == '0')	/* Mule private */ \
	    mi->Gchsets[cr] = MC_IPA; \
	else if (fin == '1')	/* Mule private */ \
	    mi->Gchsets[cr] = MC_VN1; \
	else if (fin == '2')	/* Mule private */ \
	    mi->Gchsets[cr] = MC_VN2; \
	else \
	    mi->Gchsets[cr] = MC_ASCII;

#define	two94_des(cr, fin, mi)	\
	if ('@' <= fin && fin <= 'D') \
	    mi->Gchsets[cr] = iso_fin_two94[fin-'@']; \
	else if (fin == '0')	/* Mule private */ \
	    mi->Gchsets[cr] = MC_BIG51; \
	else if (fin == '1')	/* Mule private */ \
	    mi->Gchsets[cr] = MC_BIG52;

do_escape(f, mi)
FILE *f;
mlcinfo *mi;
{
    int desreg;		/* designated register */
    int isonebyte;	/* one byte charset? */
    int i, fin;

    isonebyte = TRUE;
    if ((i = getc(f)) == '$') {	/* two byte charset */
	isonebyte = FALSE;
	i = getc(f);
	if ('@' <= i && i <= 'B') {
	    mi->G0set = iso_fin_two94[i-'@'];
	    desreg = G0reg;
	} else if ('(' <= i && i <= '+') {
	    fin = getc(f);
	    desreg = G0reg+(i-'(');
	    two94_des(desreg, fin, mi);
	} else if (',' <= i && i <= '/') {	/* no two byte 96 charset */
	    getc(f);
	    /*desreg = G0reg+(i-',');*/
	    desreg = GEreg;
	} else {
	    /* Web procedure should be called for a better error handling. */
	    fprintf(stderr,"\nText line contains an invalid escape sequence\n");
	    desreg = GEreg;
	}
    } else if ('(' <= i && i <= '+') {
	fin = getc(f);
	desreg = G0reg+(i-'(');
	one94_des(desreg, fin, mi);
    } else if (',' <= i && i <= '/') {
	fin = getc(f);
	desreg = G0reg+(i-',');
	one96_des(desreg, fin, mi);
    } else if (i == 'N') {
	desreg = GEreg;
    } else if (i == 'O') {
	desreg = GEreg;
    } else {
	/* Web procedure should be called for a better error handling. */
	fprintf(stderr,"\nText line contains an invalid escape sequence\n");
	desreg = GEreg;
    }

    if (desreg == mi->GLinvk) {
	mi->GLset = mi->Gchsets[desreg];
	if (isonebyte) {
	    mi->GLchar = left_1ch;
	} else {
	    mi->GLchar = left_pend;
	    if (mi->GLset == MC_JP || mi->GLset == MC_JPOLD)
		mi->GLmake = left_make_jp;
	    else
		mi->GLmake = left_make;
	}
    } else if (desreg == mi->GRinvk) {
	mi->GRset = mi->Gchsets[desreg];
	if (isonebyte) {
	    mi->GRchar = right_1ch;
	} else {
	    mi->GRchar = right_pend;
	    if (mi->GRset == MC_JP || mi->GRset == MC_JPOLD)
		mi->GRmake = right_make_jp;
	    else
		mi->GRmake = right_make;
	}
    }
}

do_GLlockshift(chreg, mi)
unsigned char chreg;
mlcinfo *mi;
{
    mi->GLinvk = chreg;
    mi->GLset = mi->Gchsets[chreg];
    if (mi->GLset >= MC_NONE) {
	mi->GLset = MC_NONE;
	mi->GLchar = ignore_1ch;
    } else if (ml_font_blen(mi->GLset) == 2) {
	mi->GLchar = left_pend;
	mi->GLmake = left_make;
    } else
	mi->GLchar = left_1ch;
}

do_GRlockshift(chreg, mi)
unsigned char chreg;
mlcinfo *mi;
{
    mi->GRinvk = chreg;
    mi->GRset = mi->Gchsets[chreg];
    if (mi->GRset >= MC_NONE) {
	if (mi->GRset == MC_NONE) {
	    mi->GRchar = ignore_1ch;
	} else if (mi->GRset == MC_EIGHT) {
	    mi->GRchar = eight_1ch;
	} else if (mi->GRset == MC_SJIS) {
	    mi->GRchar = sjis_pend;
	    mi->GRmake = sjis_make;
	} else if (mi->GRset == MC_BIG5h) {
	    mi->GRchar = right_pend;
	    mi->GRmake = big5h_make;
	} else if (mi->GRset == MC_BIG5e) {
	    mi->GRchar = right_pend;
	    mi->GRmake = big5e_make;
	} else {
	    mi->GRset = MC_ASCII;
	    mi->GRchar = right_1ch;
	}
    } else if (ml_font_blen(mi->GRset) == 2) {
	mi->GRchar = right_pend;
	mi->GRmake = right_make;
    } else
	mi->GRchar = right_1ch;
}

int in_ln_iso(f, mi)
FILE *f;
mlcinfo *mi;
{
    int i;

    while (last < bufsize &&
	   ((i = getc(f)) != EOF) && i != '\n' && i != '\r') {
	if (mi->instat == ISO_GL22) {
	    (*(mi->GLmake))(i, mi);
	} else if (mi->instat == ISO_GR22) {
	    (*(mi->GRmake))(i, mi);
	} else if (Lctrl(i)) {	/* i in C0 */
	    if (mi->iso)
		switch (i) {
		case ESC:
		    do_escape(f, mi);
		    continue;
		case SI:
		    do_GLlockshift(G0reg, mi);
		    continue;
		case SO:
		    do_GLlockshift(G1reg, mi);
		    continue;
		}
	    if (last >= bufsize)
		return i;
	    buffer[last++] = i;
	} else {
	    if (last >= bufsize)
		return i;
	    if (!(i&0x80))	/* i in GL */
		(*(mi->GLchar))(i, mi);
	    else		/* i in C1 or GR */
		(*(mi->GRchar))(i, mi);
	}
    }
    return i;
}

/*
 * Output
 */
#define	out_esc_seq(mc, f) \
{ \
    putc(ESC, f); fputs(iso_esc_tab[mc], f); \
}

Fputc(c, f)
mlchar c;
FILE *f;
{
    mlcinfo *mi;

    mi = &mlcodeinfo[fileno(f)];
    (*(mi->out_ch))(c, f, mi);
}

out_ch_ascii(c, f, mi)
mlchar c;
FILE *f;
mlcinfo *mi;
{
    if (is_mlrep_ascii(c)) {
	putc(c, f);
    } else { /* TODO */
	fprintf(f, "[%x|%x]", mlrep_mc(c), mlrep_char(c));
    }
}

no_out_ch(c, f, mi)
mlchar c;
FILE *f;
mlcinfo *mi;
{
    return FALSE;
}

right_out_ch(c, f, mi)
mlchar c;
FILE *f;
mlcinfo *mi;
{
    int mc;
    textchar c1, c2;

    if ((mc = mlrep_mc(c)) != mi->GRout)
	return FALSE;
    if (ml_font_blen(mc) == 2) {
	mlchar2euc(c, c1, c2);
	putc(c1, f); putc(c2, f);
    } else {
	mlchar2r(c, c1);
	putc(c1, f);
    }
    return TRUE;
}

eight_out_ch(c, f, mi)
mlchar c;
FILE *f;
mlcinfo *mi;
{
    if (mlrep_mc(c) != MC_ASCII)
	return FALSE;
    if (mi->GLset != MC_ASCII) {
	out_esc_seq(MC_ASCII, f);
	mi->GLset = MC_ASCII;
    }
    putc(c, f);
    return TRUE;
}

sjis_out_ch(c, f, mi)
mlchar c;
FILE *f;
mlcinfo *mi;
{
    int mc;
    textchar c1, c2;

    mc = mlrep_mc(c);
    if (mc == MC_JP || mc == MC_JPOLD) {
	if (mi->GLset != mc && mi->GLset != MC_ASCII) {
	    out_esc_seq(MC_ASCII, f);
	    mi->GLset = MC_ASCII;
	}
	mlchar2sj(c, c1, c2);
	putc(c1, f); putc(c2, f);
	return TRUE;
    } else if (mc == MC_KANA) {
	if (mi->GLset != mc && mi->GLset != MC_ASCII) {
	    out_esc_seq(MC_ASCII, f);
	    mi->GLset = MC_ASCII;
	}
	putc(mlrep_char(c)|0x80, f);
	return TRUE;
    } else
	return FALSE;
}

big5h_out_ch(c, f, mi)
mlchar c;
FILE *f;
mlcinfo *mi;
{
    int mc;
    textchar c1, c2;

    mc = mlrep_mc(c);
    if (mc == MC_BIG51 || mc == MC_BIG52) {
	if (mi->GLset != mc && mi->GLset != MC_ASCII) {
	    out_esc_seq(MC_ASCII, f);
	    mi->GLset = MC_ASCII;
	}
	mlchar2bvh(mc, c, c1, c2);
	putc(c1, f); putc(c2, f);
	return TRUE;
    } else
	return FALSE;
}

big5e_out_ch(c, f, mi)
mlchar c;
FILE *f;
mlcinfo *mi;
{
    int mc;
    textchar c1, c2;

    mc = mlrep_mc(c);
    if (mc == MC_BIG51 || mc == MC_BIG52) {
	if (mi->GLset != mc && mi->GLset != MC_ASCII) {
	    out_esc_seq(MC_ASCII, f);
	    mi->GLset = MC_ASCII;
	}
	mlchar2bve(mc, c, c1, c2);
	putc(c1, f); putc(c2, f);
	return TRUE;
    } else
	return FALSE;
}

out_ch_iso(c, f, mi)
mlchar c;
FILE *f;
mlcinfo *mi;
{
    int mc;
    textchar c1, c2;

    if ((*(mi->GRoutchar))(c, f, mi)) {
    } else {
	if ((mc = mlrep_mc(c)) != mi->GLset) {
	    out_esc_seq(mc, f);
	}
	if (ml_font_blen(mc) == 2) {
	    mlchar2iso(c, c1, c2);
	    putc(c1, f); putc(c2, f);
	} else {
	    putc(mlrep_char(c), f);
	}
	mi->GLset = mc;
    }
}

/*
 * Dvi-special
 */
/*
#define	specchstart	spec_ch_start
#define	specch		spec_ch
#define	specpoollen	spec_pool_len
#define	getspecch	get_spec_ch
*/
#define	spec_ch_start	specchstart
#define	spec_ch		specch
#define	spec_pool_len	specpoollen
#define	get_spec_ch	getspecch

#define	SPEC_POOL_SIZE	2048
mlcinfo spec_mlcodeinfo;
textchar *spec_pool = NULL;
textchar *spec_ptr = NULL;
textchar *spec_end = NULL;
int spec_pool_size;

#define	spec_esc_seq(mc) \
{ \
    textchar *e; \
    specc(ESC); \
    for (e = iso_esc_tab[mc]; *e != '\0'; e++) \
	specc(*e); \
}

specc(c)
mlchar c;
{
    textchar *p;
    int size;

    if (spec_ptr >= spec_end) {
	size = spec_pool_size+SPEC_POOL_SIZE;
	if ((p = realloc(spec_pool, size)) == NULL) {
	    fprintf(stderr, "no spec pool\n");
	    exit(1);
	}
	spec_pool = p;
	spec_pool_size = size;
	spec_end = spec_pool+spec_pool_size;
    }
    *spec_ptr++ = c;
}

spec_ch_start()
{
    if (spec_pool == NULL) {
	spec_pool_size = SPEC_POOL_SIZE;
	spec_pool = malloc(spec_pool_size);
	spec_end = spec_pool+spec_pool_size;
    }
    spec_ptr = spec_pool;
}

spec_ch(c)
mlchar c;
{
    mlcinfo *mi;

    mi = &spec_mlcodeinfo;
    (*(mi->out_ch))(c, mi);
}

spec_ch_ascii(c, mi)
mlchar c;
mlcinfo *mi;
{
    if (is_mlrep_ascii(c)) {
	specc(c);
    } else { /* TODO */
	/*fprintf(f, "[%x|%x]", mlrep_mc(c), mlrep_char(c));*/
    }
}

no_spec_ch(c, mi)
mlchar c;
mlcinfo *mi;
{
    return FALSE;
}

right_spec_ch(c, mi)
mlchar c;
mlcinfo *mi;
{
    int mc;
    textchar c1, c2;

    if ((mc = mlrep_mc(c)) != mi->GRout)
	return FALSE;
    if (ml_font_blen(mc) == 2) {
	mlchar2euc(c, c1, c2);
	specc(c1); specc(c2);
    } else {
	mlchar2r(c, c1);
	specc(c1);
    }
    return TRUE;
}

eight_spec_ch(c, mi)
mlchar c;
mlcinfo *mi;
{
    if (mlrep_mc(c) != MC_ASCII)
	return FALSE;
    if (mi->GLset != MC_ASCII) {
	spec_esc_seq(MC_ASCII);
	mi->GLset = MC_ASCII;
    }
    specc(c);
    return TRUE;
}

sjis_spec_ch(c, mi)
mlchar c;
mlcinfo *mi;
{
    int mc;
    textchar c1, c2;

    mc = mlrep_mc(c);
    if (mc == MC_JP || mc == MC_JPOLD) {
	if (mi->GLset != mc && mi->GLset != MC_ASCII) {
	    spec_esc_seq(MC_ASCII);
	    mi->GLset = MC_ASCII;
	}
	mlchar2sj(c, c1, c2);
	specc(c1); specc(c2);
	return TRUE;
    } else if (mc == MC_KANA) {
	if (mi->GLset != mc && mi->GLset != MC_ASCII) {
	    spec_esc_seq(MC_ASCII);
	    mi->GLset = MC_ASCII;
	}
	specc(mlrep_char(c)|0x80);
	return TRUE;
    } else
	return FALSE;
}

big5h_spec_ch(c,mi)
mlchar c;
mlcinfo *mi;
{
    int mc;
    textchar c1, c2;

    mc = mlrep_mc(c);
    if (mc == MC_BIG51 || mc == MC_BIG52) {
	if (mi->GLset != mc && mi->GLset != MC_ASCII) {
	    spec_esc_seq(MC_ASCII);
	    mi->GLset = MC_ASCII;
	}
	mlchar2bvh(mc, c, c1, c2);
	specc(c1); specc(c2);
	return TRUE;
    } else
	return FALSE;
}

big5e_spec_ch(c, f, mi)
mlchar c;
FILE *f;
mlcinfo *mi;
{
    int mc;
    textchar c1, c2;

    mc = mlrep_mc(c);
    if (mc == MC_BIG51 || mc == MC_BIG52) {
	if (mi->GLset != mc && mi->GLset != MC_ASCII) {
	    spec_esc_seq(MC_ASCII);
	    mi->GLset = MC_ASCII;
	}
	mlchar2bve(mc, c, c1, c2);
	specc(c1); specc(c2);
	return TRUE;
    } else
	return FALSE;
}

spec_ch_iso(c, mi)
mlchar c;
mlcinfo *mi;
{
    int mc;
    textchar *e, c1, c2;

    if ((*(mi->GRoutchar))(c, mi)) {
    } else {
	if ((mc = mlrep_mc(c)) != mi->GLset) {
	    spec_esc_seq(mc);
	}
	if (ml_font_blen(mc) == 2) {
	    mlchar2iso(c, c1, c2);
	    specc(c1); specc(c2);
	} else {
	    specc(mlrep_char(c));
	}
	mi->GLset = mc;
    }
}

spec_pool_len()
{
    return (spec_ptr-spec_pool);
}

textchar
get_spec_ch()
{
    return *spec_ptr++;
}

/*
 * Initialize
 */
defaultiomlcodetype(in, out)
FILE *in, *out;
{
    setinmlcodetype(in, make_ict(0,MC_ASCII,MC_ASCII));
    setoutmlcodetype(out, make_oct(0,MC_ASCII));
}

initallmlcodetype()
{
    setallmlcodetype(make_ict(1,MC_ASCII,MC_ASCII), make_oct(1,MC_ASCII));
}

str2ct(code, mkct, isct)
char *code;
int (*mkct)();
int *isct;
{
    int c, d;
    char *s;

    *isct = true;
    if (strcmp(code, "ascii") == 0 || strcmp(code, "tex") == 0)
	return (*mkct)(0,MC_ASCII);
    else if (strcmp(code, "jis7") == 0 || strcmp(code, "iso-2022-7bit") == 0)
	return (*mkct)(1,MC_ASCII);
    else if (strcmp(code, "junet") == 0 || strcmp(code, "euc") == 0 ||
	     strcmp(code, "euc-japan") == 0 || strcmp(code, "euc-jp") == 0)
	return (*mkct)(1,MC_JP);
    else if (strcmp(code, "euc-china") == 0 || strcmp(code, "euc-cn") == 0)
	return (*mkct)(1,MC_CN);
    else if (strcmp(code, "euc-korea") == 0 || strcmp(code, "euc-kr") == 0)
	return (*mkct)(1,MC_KR);
    else if (strncmp(code, "latin", 5) == 0) {
	c = *(code+5)-'0';
	if (1 <= c && c <= 4)
	    return (*mkct)(1,MC_LTN1+c-1);
	else if (c == 5)
	    return (*mkct)(1,MC_LTN5);
	else
	    return (*mkct)(0,MC_LTN1);
    } else if (strncmp(code, "iso-8859-", 9) == 0) {
	c = *(code+9)-'0';
	if (1 <= c && c <= 4)
	    return (*mkct)(1,MC_LTN1+c-1);
	else if (c == 5)
	    return (*mkct)(1,MC_LTN5);
	else
	    return (*mkct)(1,MC_LTN1);
    } else if (strcmp(code, "grk") == 0)
	return (*mkct)(1,MC_GRK);
    else if (strcmp(code, "crl") == 0)
	return (*mkct)(1,MC_CRL);
    else if (strcmp(code, "sjis") == 0)
	return (*mkct)(1,MC_SJIS);
    else if (strcmp(code, "bigv") == 0)
	return (*mkct)(1,MC_BIG5h);
    else if (strcmp(code, "bigvet") == 0)
	return (*mkct)(1,MC_BIG5e);
    else {
	for (*isct = true, c = 0, s = code; *s != '\0'; s++) {
	    if ('0' <= *s && *s <= '9')
		d = *s-'0';
	    else if ('a' <= *s && *s <= 'f')
		d = *s-'a'+10;
	    else if ('A' <= *s && *s <= 'F')
		d = *s-'A'+10;
	    else {
		*isct = false;
		break;
	    }
	    c = c*16+d;
	}
	return c;
    }
}

int hasargcode = false;
static int argcode;

make_inct(iso,gr)
int iso, gr;
{
    return (make_ict(iso,MC_ASCII,gr));
}

argmlcode(code)
char *code;
{
    int isct;

    hasargcode = true;
    argcode = str2ct(code, make_inct, &isct);
    /* TODO: range check of argcode */
    if (!isct) {
	argcode = make_inct(1,MC_JP);
	fprintf(stderr,
		"No such file type %s, I will change it to junet.\n",
		code);
    }
}

getargcode()
{
    return argcode;
}

int hasargterm = false;
static int argterm;

make_outct(iso,gr)
int iso, gr;
{
    return (make_oct(iso,gr));
}

argmlterm(code)
char *code;
{
    int isct;

    hasargterm = true;
    argterm = str2ct(code, make_outct, &isct);
    /* TODO: range check of argterm */
    if (!isct) {
	argterm = make_outct(1,MC_ASCII);
	fprintf(stderr,
		"No such terminal type %s, I will change it to iso-2022-7bit.\n",
		code);
    }
}

getargterm()
{
    return argterm;
}

int hasarglog = false;
static int arglog;

argmllog(code)
char *code;
{
    int isct;

    hasarglog = true;
    arglog = str2ct(code, make_outct, &isct);
    /* TODO: range check of arglog */
    if (!isct) {
	arglog = make_outct(1,MC_ASCII);
	fprintf(stderr,
		"No such log type %s, I will change it to iso-2022-7bit.\n",
		code);
    }
}

getarglog()
{
    return arglog;
}

setinmlcodetype(f, mtype)
FILE *f;
int mtype;
{
    mlcinfo *mi = &mlcodeinfo[fileno(f)];

    mi->iso = ict_iso(mtype);
    mi->G0set = ict_G0(mtype);
    mi->G1set = ict_G1(mtype);
    mi->G2set = MC_ASCII;
    mi->G3set = MC_ASCII;
    do_GLlockshift(G0reg, mi);
    do_GRlockshift(G1reg, mi);
    mi->instat = ISO_ONE;
    if (ict_iso(mtype)) {
	if (ict_iso(mtype) == 2)
	    mi->iso = FALSE;
	mi->in_ln = in_ln_iso;
    } else
	mi->in_ln = in_ln_ascii;
}

setoutmlcodetype(f, mtype)
FILE *f;
int mtype;
{
    mlcinfo *mi = &mlcodeinfo[fileno(f)];
    int gr;

    mi->GRout = gr = oct_GR(mtype);
    if (gr == MC_NONE || gr == MC_ASCII)
	mi->GRoutchar = no_out_ch;
    else if (gr == MC_EIGHT)
	mi->GRoutchar = eight_out_ch;
    else if (gr == MC_SJIS)
	mi->GRoutchar = sjis_out_ch;
    else if (gr == MC_BIG5h)
	mi->GRoutchar = big5h_out_ch;
    else if (gr == MC_BIG5e)
	mi->GRoutchar = big5e_out_ch;
    else
	mi->GRoutchar = right_out_ch;
    if (oct_iso(mtype))
	mi->out_ch = out_ch_iso;
    else
	mi->out_ch = out_ch_ascii;
}

int hasargspec = false;
static int argspec;

argmlspec(code)
char *code;
{
    int isct;

    hasargspec = true;
    argspec = str2ct(code, make_outct, &isct);
    /* TODO: range check of argspec */
    if (!isct) {
	argspec = make_outct(1,MC_JP);
	fprintf(stderr,
		"No such special type %s, I will change it to euc-jp.\n",
		code);
    }
}

getargspec()
{
    return argspec;
}

setspecmlcodetype(mtype)
int mtype;
{
    mlcinfo *mi = &spec_mlcodeinfo;
    int gr;

    mi->GRout = gr = oct_GR(mtype);
    if (gr == MC_NONE || gr == MC_ASCII)
	mi->GRoutchar = no_spec_ch;
    else if (gr == MC_EIGHT)
	mi->GRoutchar = eight_spec_ch;
    else if (gr == MC_SJIS)
	mi->GRoutchar = sjis_spec_ch;
    else if (gr == MC_BIG5h)
	mi->GRoutchar = big5h_spec_ch;
    else if (gr == MC_BIG5e)
	mi->GRoutchar = big5e_spec_ch;
    else
	mi->GRoutchar = right_spec_ch;
    if (oct_iso(mtype))
	mi->out_ch = spec_ch_iso;
    else
	mi->out_ch = spec_ch_ascii;
}

setinmlmcs(t, fin, mcs)
int t, fin, mcs;
{
    if (t == 1) {
	iso_fin_one94[fin-'@'] = mcs;
    } else if (t == 2) {
	iso_fin_one96[fin-'@'] = mcs;
    } else if (t == 3) {
	if (fin <= 'D')
	    iso_fin_two94[fin-'@'] = mcs;
    }
}

setoutmlfin(mcs, fin)
int mcs, fin;
{
    char *esc;

    if (mcs <= MC_BIG52) {
	esc = iso_esc_tab[mcs];
	*(esc+strlen(esc)-1) = fin;
    }
}

/*
 * Dump and undump
 */
dumpiotabs()
{
    dumpthings(iso_fin_one94[0], MAX_ONE94_IDX+1);
    dumpthings(iso_fin_one96[0], MAX_ONE96_IDX+1);
    dumpthings(iso_fin_two94[0], MAX_TWO_IDX+1);
    dumpthings(iso_esc_tab[0], MAX_ESC_IDX+1);
}

undumpiotabs()
{
    undumpthings(iso_fin_one94[0], MAX_ONE94_IDX+1);
    undumpthings(iso_fin_one96[0], MAX_ONE96_IDX+1);
    undumpthings(iso_fin_two94[0], MAX_TWO_IDX+1);
    undumpthings(iso_esc_tab[0], MAX_ESC_IDX+1);
}
